/*
 * Decompiled with CFR 0.152.
 */
package aliview.settings;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public final class RegexInputVerifier
extends InputVerifier {
    private String defaultValue;
    static final String ERROR_MESSAGE_START = "INVALID: ";
    private Matcher fMatcher;
    private boolean fUseToolTip;
    private static final String TEXT_FIELD = "^(\\S)(.){1,75}(\\S)$";
    private static final String NON_NEGATIVE_INTEGER_FIELD = "(\\d){1,9}";
    private static final String INTEGER_FIELD = "(-)?(\\d){1,9}";
    private static final String NON_NEGATIVE_FLOATING_POINT_FIELD = "(\\d){1,10}\\.(\\d){1,10}";
    private static final String FLOATING_POINT_FIELD = "(-)?(\\d){1,10}\\.(\\d){1,10}";
    private static final String NON_NEGATIVE_MONEY_FIELD = "(\\d){1,15}(\\.(\\d){2})?";
    private static final String MONEY_FIELD = "(-)?(\\d){1,15}(\\.(\\d){2})?";
    static final RegexInputVerifier INTEGER = new RegexInputVerifier(Pattern.compile("(-)?(\\d){1,9}"), UseToolTip.FALSE);
    static final RegexInputVerifier NON_NEGATIVE_INTEGER = new RegexInputVerifier(Pattern.compile("(\\d){1,9}"), UseToolTip.FALSE);
    static final RegexInputVerifier TEXT = new RegexInputVerifier(Pattern.compile("^(\\S)(.){1,75}(\\S)$"), UseToolTip.FALSE);
    static final RegexInputVerifier FLOATING_POINT = new RegexInputVerifier(Pattern.compile("(-)?(\\d){1,10}\\.(\\d){1,10}"), UseToolTip.FALSE);
    static final RegexInputVerifier NON_NEGATIVE_FLOATING_POINT = new RegexInputVerifier(Pattern.compile("(\\d){1,10}\\.(\\d){1,10}"), UseToolTip.FALSE);
    static final RegexInputVerifier MONEY = new RegexInputVerifier(Pattern.compile("(-)?(\\d){1,15}(\\.(\\d){2})?"), UseToolTip.FALSE);
    static final RegexInputVerifier NON_NEGATIVE_MONEY = new RegexInputVerifier(Pattern.compile("(\\d){1,15}(\\.(\\d){2})?"), UseToolTip.FALSE);

    RegexInputVerifier(Pattern aPattern, UseToolTip aUseToolTip) {
        this.fMatcher = aPattern.matcher("");
        this.fUseToolTip = aUseToolTip.getValue();
    }

    public RegexInputVerifier(Pattern aPattern, UseToolTip aUseToolTip, String defaultValue) {
        this.fMatcher = aPattern.matcher("");
        this.fUseToolTip = aUseToolTip.getValue();
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean shouldYieldFocus(JComponent aComponent) {
        boolean isValid = super.shouldYieldFocus(aComponent);
        if (isValid) {
            return true;
        }
        JTextComponent textComponent = (JTextComponent)aComponent;
        this.notifyUserOfError(textComponent);
        return false;
    }

    @Override
    public boolean verify(JComponent aComponent) {
        System.out.println("verify");
        boolean result = false;
        JTextComponent textComponent = (JTextComponent)aComponent;
        this.fMatcher.reset(textComponent.getText());
        if (this.fMatcher.matches()) {
            result = true;
        }
        return result;
    }

    private void notifyUserOfError(JTextComponent aTextComponent) {
        if (!this.isShowingErrorMessage(aTextComponent)) {
            this.showErrorMessage(aTextComponent);
        }
    }

    private boolean isShowingErrorMessage(JTextComponent aTextComponent) {
        return aTextComponent.getText().startsWith(ERROR_MESSAGE_START);
    }

    private void showErrorMessage(JTextComponent aTextComponent) {
        StringBuilder message = new StringBuilder(ERROR_MESSAGE_START);
        message.append("\"");
        message.append(aTextComponent.getText());
        message.append("\"");
        if (this.fUseToolTip) {
            message.append(aTextComponent.getToolTipText());
        }
        aTextComponent.setText(message.toString());
    }

    static enum UseToolTip {
        TRUE(true),
        FALSE(false);

        private boolean fToggle;

        boolean getValue() {
            return this.fToggle;
        }

        private UseToolTip(boolean aToggle) {
            this.fToggle = aToggle;
        }
    }
}

