/*
 * Decompiled with CFR 0.152.
 */
package aliview.settings;

import aliview.aligner.AlignerADDItemsPanel;
import aliview.aligner.AlignerALLItemsPanel;
import aliview.externalcommands.CmdItemsPanel;
import aliview.gui.AppIcons;
import aliview.settings.GeneralSettingsPanel;
import aliview.settings.MemorySettingsPanel;
import aliview.settings.PrimerSettingsPanel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class SettingsFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(SettingsFrame.class);
    JTabbedPane tabbedPane;
    public static final String TAB_EXTERNAL_COMMANDS = "External commands";
    public static final String TAB_GENERAL = "General";
    public static final String TAB_PRIMER = "Primer";
    public static final String TAB_ALIGN_ALL = "Align ALL program";
    public static final String TAB_ALIGN_ADD = "Align ADD program";
    public static final String TAB_MEMORY = "Memory";

    public SettingsFrame(Component parent) {
        this.init();
        this.setAlwaysOnTop(true);
        this.pack();
        this.centerLocationToThisComponent(parent);
    }

    private void init() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(TAB_GENERAL, new GeneralSettingsPanel(this));
        this.tabbedPane.add(TAB_PRIMER, new PrimerSettingsPanel(this));
        this.tabbedPane.add(TAB_ALIGN_ALL, new AlignerALLItemsPanel(this));
        this.tabbedPane.add(TAB_ALIGN_ADD, new AlignerADDItemsPanel(this));
        this.tabbedPane.add(TAB_EXTERNAL_COMMANDS, new CmdItemsPanel(this));
        this.tabbedPane.add(TAB_MEMORY, new MemorySettingsPanel(this));
        this.getContentPane().add(this.tabbedPane);
        this.setIconImage(AppIcons.getProgramIconImage());
        this.setTitle("Settings");
        this.setPreferredSize(new Dimension(750, 600));
    }

    public void reload() {
        int index = this.tabbedPane.getSelectedIndex();
        this.getContentPane().remove(this.tabbedPane);
        this.init();
        this.tabbedPane.setSelectedIndex(index);
        this.validate();
    }

    public void selectTab(String name) {
        int tabIndex = 0;
        for (int n = 0; n < this.tabbedPane.getTabCount(); ++n) {
            if (!this.tabbedPane.getTitleAt(n).equals(name)) continue;
            tabIndex = n;
        }
        this.tabbedPane.setSelectedIndex(tabIndex);
    }

    public void centerLocationToThisComponent(Component parent) {
        if (parent != null) {
            int newX = parent.getX() + parent.getWidth() / 2 - this.getWidth() / 2;
            int newY = parent.getY() + parent.getHeight() / 2 - this.getHeight() / 2;
            this.setLocation(newX, newY);
        }
    }
}

