/*
 * Decompiled with CFR 0.152.
 */
package aliview.subprocesses;

import aliview.gui.AppIcons;
import aliview.messenges.Messenger;
import aliview.settings.Settings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SubProcessWindow {
    private JDialog dialog;
    private static final Logger logger = Logger.getLogger(SubProcessWindow.class);
    private Process subProcess;
    private JTextArea consoleTextArea;
    private boolean subProcessDestrouedByUser = false;
    private Dimension preferredSize = new Dimension(500, 350);
    private JFrame parentFrame;
    private JCheckBox closeAutomaticCbx = new JCheckBox("Default checkbox message");

    public SubProcessWindow(JFrame parentFrame) {
        this.init(parentFrame, false);
    }

    public SubProcessWindow(JFrame parentFrame, boolean withAutoCloseWhenDoneCbx) {
        this.init(parentFrame, true);
    }

    public static SubProcessWindow getProcessProgressWindow(JFrame parentFrame, boolean autoCloseWhenDoneCbxSelected) {
        SubProcessWindow procWin = new SubProcessWindow(parentFrame, true);
        procWin.closeAutomaticCbx.setText("Close this type of progress window automatically when done");
        procWin.closeAutomaticCbx.setSelected(autoCloseWhenDoneCbxSelected);
        procWin.closeAutomaticCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox box = (JCheckBox)e.getSource();
                Settings.getHideProcessProgressWindowWhenDone().putBooleanValue(box.isSelected());
            }
        });
        return procWin;
    }

    public void init(final JFrame parentFrame, boolean withAutocloseBox) {
        this.parentFrame = parentFrame;
        this.dialog = new JDialog(parentFrame);
        this.consoleTextArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.consoleTextArea, 20, 30);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SubProcessWindow.this.subProcess != null) {
                    logger.info("destroy-subprocess");
                    logger.info("before destroy");
                    SubProcessWindow.this.subProcessDestrouedByUser = true;
                    SubProcessWindow.this.subProcess.destroy();
                    logger.info("now after destroy");
                    Messenger.showOKOnlyMessage(Messenger.SUBPROCESS_CANCELLED_SUCCESSFULLY, parentFrame);
                }
                SubProcessWindow.this.dialog.dispose();
            }
        });
        this.dialog.getContentPane().add((Component)scrollPane, "Center");
        if (withAutocloseBox) {
            this.closeAutomaticCbx.setHorizontalAlignment(0);
            this.dialog.getContentPane().add((Component)this.closeAutomaticCbx, "South");
        }
        this.dialog.setTitle("Sub Process Window");
        this.dialog.setIconImage(AppIcons.getProgramIconImage());
        this.dialog.setIconImage(Toolkit.getDefaultToolkit().getImage(SubProcessWindow.class.getResource("/img/alignment_ico_128x128.png")));
    }

    public void show() {
        this.dialog.setPreferredSize(this.preferredSize);
        this.dialog.pack();
        if (this.parentFrame != null) {
            int newX = this.parentFrame.getX() + this.parentFrame.getWidth() / 2 - this.dialog.getPreferredSize().width / 2;
            int newY = this.parentFrame.getY() + this.parentFrame.getHeight() / 2 - this.dialog.getPreferredSize().height / 2;
            this.dialog.setLocation(newX, newY);
        }
        this.dialog.setVisible(true);
    }

    public void setPreferredSize(Dimension prefSize) {
        this.preferredSize = prefSize;
    }

    public SubProcessWindow(Process subprocess) {
        this.subProcess = subprocess;
    }

    public boolean wasSubProcessDestrouedByUser() {
        return this.subProcessDestrouedByUser;
    }

    public void setActiveProcess(Process subProcess) {
        this.subProcess = subProcess;
    }

    public void placeFrameupperLeftLocationOfThis(Component parent) {
        if (parent != null) {
            int newX = parent.getX() + 100;
            int newY = parent.getY() + 100;
            this.dialog.setLocation(newX, newY);
        }
    }

    public void appendOutput(final String output) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubProcessWindow.this.consoleTextArea.append(output);
                SubProcessWindow.this.consoleTextArea.setCaretPosition(SubProcessWindow.this.consoleTextArea.getDocument().getLength());
            }
        });
    }

    public void setMessage(String output) {
        this.setOutput(output);
    }

    public void setOutput(final String output) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubProcessWindow.this.consoleTextArea.setText(output);
                SubProcessWindow.this.consoleTextArea.setCaretPosition(SubProcessWindow.this.consoleTextArea.getDocument().getLength());
            }
        });
    }

    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.dialog.setAlwaysOnTop(alwaysOnTop);
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public Component getFrame() {
        return this.dialog;
    }

    public void setVisible(boolean b) {
    }

    public boolean isCloseWhenDoneCbxSelected() {
        if (this.closeAutomaticCbx != null) {
            return this.closeAutomaticCbx.isSelected();
        }
        return false;
    }

    public void setCloseWhenDoneCbxSelection(boolean booleanValue) {
        if (this.closeAutomaticCbx != null) {
            this.closeAutomaticCbx.setSelected(booleanValue);
        }
    }

    public void setCloseWhenDoneCbxText(String text) {
        if (this.closeAutomaticCbx != null) {
            this.closeAutomaticCbx.setText(text);
        }
    }
}

