/*
 * Decompiled with CFR 0.152.
 */
package aliview.subprocesses;

import aliview.gui.AppIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SubThreadProgressWindow {
    private JFrame frame;
    private static final Logger logger = Logger.getLogger(SubThreadProgressWindow.class);
    private Thread subThread;
    private JTextArea consoleTextArea;
    private boolean subThreadInterruptedByUser = false;

    public SubThreadProgressWindow() {
        this.init();
    }

    public void init() {
        this.frame = new JFrame();
        this.consoleTextArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.consoleTextArea, 20, 30);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SubThreadProgressWindow.this.subThread != null) {
                    SubThreadProgressWindow.this.subThread.interrupt();
                    SubThreadProgressWindow.this.subThreadInterruptedByUser = true;
                }
                SubThreadProgressWindow.this.frame.dispose();
            }
        });
        this.frame.getContentPane().add((Component)scrollPane, "Center");
        this.frame.setTitle("Working");
        this.frame.setIconImage(AppIcons.getProgramIconImage());
        this.frame.setIconImage(Toolkit.getDefaultToolkit().getImage(SubThreadProgressWindow.class.getResource("/img/alignment_ico_128x128.png")));
    }

    public void pack() {
        this.frame.pack();
    }

    public void show() {
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public SubThreadProgressWindow(Thread subthread) {
        this.subThread = subthread;
    }

    public boolean wasSubThreadInterruptedByUser() {
        return this.subThreadInterruptedByUser;
    }

    public void setActiveThread(Thread subThread) {
        this.subThread = subThread;
    }

    public void centerLocationToThisComponentOrScreen(Component parent) {
        if (parent != null) {
            int newX = parent.getX() + parent.getWidth() / 2 - this.frame.getPreferredSize().width / 2;
            int newY = parent.getY() + parent.getHeight() / 2 - this.frame.getPreferredSize().height / 2;
            logger.info(parent.getX());
            logger.info(parent.getWidth());
            logger.info(this.frame.getWidth());
            this.setLocation(newX, newY);
        } else {
            this.centerLocationToCenterOfScreen();
        }
    }

    public void setBottomRightRelativeThisComponent(Component parent) {
        if (parent != null) {
            int newX = parent.getX() + parent.getWidth() - this.frame.getPreferredSize().width - 50;
            int newY = parent.getY() + parent.getHeight() - this.frame.getPreferredSize().height - 50;
            logger.info(parent.getX());
            logger.info(parent.getWidth());
            logger.info(this.frame.getWidth());
            this.setLocation(newX, newY);
        } else {
            this.centerLocationToCenterOfScreen();
        }
    }

    public void setTopRightRelativeThisComponent(Component parent) {
        if (parent != null) {
            int newX = parent.getX() + parent.getWidth() - this.frame.getPreferredSize().width - 20;
            int newY = parent.getY() + 150;
            logger.info(parent.getX());
            logger.info(parent.getWidth());
            logger.info(this.frame.getWidth());
            this.setLocation(newX, newY);
        } else {
            this.centerLocationToCenterOfScreen();
        }
    }

    public void centerLocationToCenterOfScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - this.frame.getPreferredSize().getWidth()) / 2.0);
        int y = (int)((dimension.getHeight() - this.frame.getPreferredSize().getHeight()) / 2.0);
        logger.info(this.frame.getPreferredSize());
        this.setLocation(x, y);
    }

    private void setLocation(final int x, final int y) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubThreadProgressWindow.this.frame.setLocation(x, y);
            }
        });
    }

    public void upperLeftLocationOfThisComponent(Component parent) {
        if (parent != null) {
            int newX = parent.getX() + 100;
            int newY = parent.getY() + 100;
            this.setLocation(newX, newY);
        }
    }

    public void appendOutput(final String output) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubThreadProgressWindow.this.consoleTextArea.append(output);
                SubThreadProgressWindow.this.consoleTextArea.setCaretPosition(SubThreadProgressWindow.this.consoleTextArea.getDocument().getLength());
            }
        });
    }

    public void setInitialMessage(String output) {
        this.consoleTextArea.setText(output);
        this.consoleTextArea.setCaretPosition(this.consoleTextArea.getDocument().getLength());
    }

    public void setMessage(final String output) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubThreadProgressWindow.this.consoleTextArea.setText(output);
                SubThreadProgressWindow.this.consoleTextArea.setCaretPosition(SubThreadProgressWindow.this.consoleTextArea.getDocument().getLength());
            }
        });
    }

    public void setOutput(final String output) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubThreadProgressWindow.this.consoleTextArea.setText(output);
                SubThreadProgressWindow.this.consoleTextArea.setCaretPosition(SubThreadProgressWindow.this.consoleTextArea.getDocument().getLength());
            }
        });
    }

    public void setTitle(final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubThreadProgressWindow.this.frame.setTitle(title);
            }
        });
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.frame.setAlwaysOnTop(alwaysOnTop);
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public Component getFrame() {
        return this.frame;
    }

    public void setVisible(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubThreadProgressWindow.this.frame.setVisible(b);
            }
        });
    }
}

