/*
 * Decompiled with CFR 0.152.
 */
package aliview.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DropDemo
extends JPanel
implements ActionListener {
    private JComboBox dropCombo;
    private JList list;

    public DropDemo() {
        super(new GridLayout(2, 1));
        this.add(this.createArea());
        this.add(this.createList());
    }

    private JPanel createList() {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (int i = 0; i < 10; ++i) {
            listModel.addElement("List Item " + i);
        }
        this.list = new JList(listModel);
        this.list.setSelectionMode(1);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setPreferredSize(new Dimension(400, 100));
        this.list.setDragEnabled(true);
        this.dropCombo = new JComboBox<String>(new String[]{"USE_SELECTION", "ON", "INSERT", "ON_OR_INSERT"});
        this.dropCombo.addActionListener(this);
        JPanel dropPanel = new JPanel();
        dropPanel.add(new JLabel("List Drop Mode:"));
        dropPanel.add(this.dropCombo);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)scrollPane, "Center");
        panel2.add((Component)dropPanel, "South");
        panel2.setBorder(BorderFactory.createTitledBorder("List"));
        return panel2;
    }

    private JPanel createArea() {
        String text = "Drag from or drop into this area.\nThe default action is MOVE;\nhold the Control key to COPY.";
        JTextArea area = new JTextArea();
        area.setText(text);
        area.setDragEnabled(true);
        JScrollPane scrollPane = new JScrollPane(area);
        scrollPane.setPreferredSize(new Dimension(400, 100));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)scrollPane, "Center");
        panel2.setBorder(BorderFactory.createTitledBorder("Text Area"));
        return panel2;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object val = this.dropCombo.getSelectedItem();
        if (val == "USE_SELECTION") {
            this.list.setDropMode(DropMode.USE_SELECTION);
        } else if (val == "ON") {
            this.list.setDropMode(DropMode.ON);
        } else if (val == "INSERT") {
            this.list.setDropMode(DropMode.INSERT);
        } else if (val == "ON_OR_INSERT") {
            this.list.setDropMode(DropMode.ON_OR_INSERT);
        }
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("DropDemo");
        frame.setDefaultCloseOperation(3);
        DropDemo newContentPane = new DropDemo();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                DropDemo.createAndShowGUI();
            }
        });
    }
}

