/*
 * Decompiled with CFR 0.152.
 */
package aliview.test;

import aliview.importer.AlignmentImportException;
import aliview.sequences.FastFastaSequence;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.bitbucket.kienerj.io.OptimizedRandomAccessFile;

public class FastFastaFileTest {
    private static final Logger logger = Logger.getLogger(FastFastaFileTest.class);
    private int longestSequenceLength;

    public static void main(String[] args) {
        FastFastaFileTest ffFileTest = new FastFastaFileTest();
        try {
            ffFileTest.importSequences();
        }
        catch (AlignmentImportException e) {
            e.printStackTrace();
        }
    }

    public static void importSequences() throws AlignmentImportException {
        long startTime = System.currentTimeMillis();
        ArrayList<FastFastaSequence> sequences = new ArrayList<FastFastaSequence>();
        try {
            StringBuilder sequence = new StringBuilder();
            File seqFile = new File("/vol2/big_data/SSURef_108_filtered_bacteria_pos_5389-24317.fasta");
            OptimizedRandomAccessFile raf = new OptimizedRandomAccessFile(seqFile, "r");
            String line = "";
            String name = null;
            int nLine = 0;
            long nSeqCount = 0L;
            byte[] buffer = new byte[10000];
            while (raf.read(buffer) > 0) {
                line = line.trim();
                long filePoint = raf.getFilePointer();
                boolean findNextLF = false;
                for (int n = 0; n < buffer.length; ++n) {
                    if (buffer[n] == 62) {
                        long startPos = filePoint - (long)n;
                        ++nSeqCount;
                        findNextLF = true;
                    }
                    ++n;
                }
                ++nLine;
                if (nSeqCount % 100L == 0L) {
                    System.err.println("found seq" + nSeqCount);
                }
                if (nLine % 10000 != 0) continue;
                System.out.println("nLine" + nLine + "pointer" + raf.getFilePointer() + "nSecCount" + nSeqCount);
            }
            if (name != null && name.length() > 0) {
                String seqAsString = sequence.toString();
                seqAsString = seqAsString.replaceAll(" ", "");
                sequences.add(new FastFastaSequence(name, seqAsString));
                name = null;
            }
        }
        catch (Exception e) {
            logger.error(e);
            throw new AlignmentImportException("could not import as fasta file because: " + e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("reading sequences took " + (endTime - startTime) + " milliseconds");
    }

    public int getLongestSequenceLength() {
        return this.longestSequenceLength;
    }
}

