/*
 * Decompiled with CFR 0.152.
 */
package aliview.test;

import java.awt.Component;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import org.apache.log4j.Logger;

public class RubberBandingListener
extends MouseAdapter {
    private static final Logger logger = Logger.getLogger(RubberBandingListener.class);
    private Point srcPoint;
    private final Polygon polygon = new Polygon();

    @Override
    public void mouseDragged(MouseEvent e) {
        JList list = (JList)e.getComponent();
        if (list.getDragEnabled()) {
            return;
        }
        if (this.srcPoint == null) {
            this.srcPoint = e.getPoint();
        }
        Point destPoint = e.getPoint();
        this.polygon.reset();
        this.polygon.addPoint(this.srcPoint.x, this.srcPoint.y);
        this.polygon.addPoint(destPoint.x, this.srcPoint.y);
        this.polygon.addPoint(destPoint.x, destPoint.y);
        this.polygon.addPoint(this.srcPoint.x, destPoint.y);
        list.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JList list = (JList)e.getComponent();
        list.setFocusable(true);
        if (this.srcPoint == null || !list.getDragEnabled()) {
            Component glassPane = list.getRootPane().getGlassPane();
            glassPane.setVisible(false);
        }
        this.srcPoint = null;
        list.setDragEnabled(list.getSelectedIndices().length > 0);
        list.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        logger.info("mousePressed");
        JList list = (JList)e.getComponent();
        int index = list.locationToIndex(e.getPoint());
        Rectangle rect = list.getCellBounds(index, index);
        if (rect.contains(e.getPoint())) {
            logger.info("rect.contains(e.getPoint()");
            list.setFocusable(true);
            if (list.getDragEnabled()) {
                return;
            }
            System.out.println("ccc:");
            list.setSelectedIndex(index);
        } else {
            Component glassPane = list.getRootPane().getGlassPane();
            glassPane.setVisible(false);
            list.clearSelection();
            list.getSelectionModel().setAnchorSelectionIndex(-1);
            list.getSelectionModel().setLeadSelectionIndex(-1);
            list.setFocusable(false);
            list.setDragEnabled(false);
        }
        list.repaint();
    }
}

