/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import java.util.ArrayList;
import jebl.evolution.align.AlignLinearSpaceAffine;
import jebl.evolution.align.AlignmentResult;
import jebl.evolution.align.OldNeedlemanWunschAffine;
import jebl.evolution.align.PairwiseAligner;
import jebl.evolution.align.Profile;
import jebl.evolution.align.ProfileCharacter;
import jebl.evolution.align.SmithWatermanLinearSpaceAffine;
import jebl.evolution.align.scores.NucleotideScores;
import jebl.evolution.align.scores.Scores;
import jebl.evolution.align.scores.ScoresFactory;
import jebl.evolution.alignments.BasicAlignment;
import jebl.evolution.sequences.BasicSequence;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceTester;
import jebl.util.ProgressListener;

public class NeedlemanWunschLinearSpaceAffine
extends AlignLinearSpaceAffine
implements PairwiseAligner {
    private float resultScore;
    static final int RECURSION_THRESHOLD = 6;
    private boolean debug = false;
    private boolean freeGapsAtEnds;
    String[] matchResult;
    private static final int TYPE_ANY = 0;
    private static final int TYPE_X = 1;
    private static final int TYPE_Y = 2;
    private int[][][] C;
    private int[][][] Ctype;
    private int previousm = -1;
    private int previousn = -1;
    private ProgressListener progress;
    private long totalProgress;
    private long currentProgress;
    private boolean cancelled;
    int[][][] Bi;
    int[][][] Bj;
    int[][][] Bk;
    private int allocatedn = -1;
    private int allocatedm = -1;

    public NeedlemanWunschLinearSpaceAffine(Scores sub, float openGapPenalty, float extendGapPenalty) {
        this(sub, openGapPenalty, extendGapPenalty, false);
    }

    public NeedlemanWunschLinearSpaceAffine(Scores sub, float d, float e, boolean freeGapsAtEnds) {
        this(sub, d, e, freeGapsAtEnds, false);
    }

    public NeedlemanWunschLinearSpaceAffine(Scores sub, float d, float e, boolean freeGapsAtEnds, boolean applyGapExtendCostToFirstGapResidue) {
        super(Scores.includeAdditionalCharacters(sub, "_"), d + (applyGapExtendCostToFirstGapResidue ? e : 0.0f), e);
        this.freeGapsAtEnds = freeGapsAtEnds;
    }

    public void allocateMatrices(int n, int m) {
        if (n > m) {
            throw new IllegalStateException("n=" + n + " m=" + m);
        }
        if (n >= 6) {
            throw new IllegalStateException("n=" + n);
        }
        if (n > this.allocatedn || m > this.allocatedm) {
            if ((n = NeedlemanWunschLinearSpaceAffine.maxi(n, this.allocatedn + 5)) >= 6) {
                n = 5;
            }
            m = NeedlemanWunschLinearSpaceAffine.maxi(m, this.allocatedm + 5);
            this.allocatedn = n;
            this.allocatedm = m;
            this.Bi = new int[3][n + 1][m + 1];
            this.Bj = new int[3][n + 1][m + 1];
            this.Bk = new int[3][n + 1][m + 1];
        }
    }

    private int convertType(int type) {
        if (type == 0) {
            return type;
        }
        if (type == 1) {
            return 2;
        }
        if (type == 2) {
            return 1;
        }
        throw new RuntimeException("invalid type");
    }

    private boolean addProgress(long value) {
        this.currentProgress += value;
        if (this.progress != null) {
            double fraction = (double)this.currentProgress / (double)this.totalProgress;
            if (fraction > 1.0) {
                fraction = 1.0;
            }
            this.cancelled = this.progress.setProgress(fraction);
        }
        return this.cancelled;
    }

    public void doAlignment(String sq1, String sq2) {
        this.doAlignment(sq1, sq2, null);
    }

    public void doAlignment(String sq1, String sq2, ProgressListener progress, boolean scoreOnly) {
        this.progress = progress;
        sq1 = this.strip(sq1);
        sq2 = this.strip(sq2);
        Profile profile1 = Profile.createImmutableProfile(0, sq1);
        Profile profile2 = Profile.createImmutableProfile(0, sq2);
        AlignmentResult[] results = this.doAlignment(profile1, profile2, progress, scoreOnly);
        this.matchResult = new String[2];
        if (this.cancelled) {
            return;
        }
        this.matchResult[0] = Profile.buildAlignmentString(sq1, results[0]);
        this.matchResult[1] = Profile.buildAlignmentString(sq2, results[1]);
    }

    public void doAlignment(String sq1, String sq2, ProgressListener progress) {
        this.doAlignment(sq1, sq2, progress, false);
    }

    public static long getMemoryRequiredForAlignment(int maximumSequenceLength) {
        long memoryRequiredPerBase = 0L;
        memoryRequiredPerBase += 216L;
        return (memoryRequiredPerBase += 72L) * (long)(maximumSequenceLength + 1);
    }

    public AlignmentResult[] doAlignment(Profile profile1, Profile profile2, ProgressListener progress, boolean scoreOnly) {
        this.progress = progress;
        if (this.freeGapsAtEnds && (profile1.getNumberOfSequences() > 1 || profile2.getNumberOfSequences() > 1)) {
            profile1 = profile1.supportFreeEndGaps();
            profile2 = profile2.supportFreeEndGaps();
        }
        this.n = profile1.length();
        this.m = profile2.length();
        if (this.n > this.previousn || this.m > this.previousm) {
            int maximum = Math.max(this.m, this.n);
            this.F = new float[3][2][maximum + 1];
            this.C = new int[3][2][maximum + 1];
            this.Ctype = new int[3][3][maximum + 1];
            this.previousn = this.n;
            this.previousm = this.m;
        }
        this.totalProgress = (long)this.n * (long)this.m * 2L;
        this.currentProgress = 0L;
        this.cancelled = false;
        int maximumResultLength = this.m + this.n;
        AlignmentResult result1 = new AlignmentResult(maximumResultLength);
        AlignmentResult result2 = new AlignmentResult(maximumResultLength);
        this.resultScore = this.doAlignment(profile1, profile2, 0, 0, this.n, this.m, 0, 0, result1, result2, scoreOnly, this.freeGapsAtEnds, this.freeGapsAtEnds);
        return new AlignmentResult[]{result1, result2};
    }

    public String[] getMatch() {
        return this.matchResult;
    }

    private static float gapFraction(ProfileCharacter character) {
        float result = character.gapFraction();
        return result;
    }

    private float doAlignment(Profile profile1, Profile profile2, int offset1, int offset2, int n, int m, int startType, int endType, AlignmentResult result1, AlignmentResult result2, boolean scoreOnly, boolean freeStartGap, boolean freeEndGap) {
        float base;
        this.n = n;
        this.m = m;
        boolean gapCostProduction = true;
        float[][] M = this.F[0];
        float[][] Ix = this.F[1];
        float[][] Iy = this.F[2];
        int[][] cm = this.C[0];
        int[][] cx = this.C[1];
        int[][] cy = this.C[2];
        int[][] cmtype = this.Ctype[0];
        int[][] cxtype = this.Ctype[1];
        int[][] cytype = this.Ctype[2];
        boolean calculateResults = false;
        boolean invert = false;
        if (this.debug) {
            System.out.println("start =" + startType + ", end=" + endType + " free =" + freeStartGap + "," + freeEndGap);
            System.out.println("align from " + offset1 + " to " + (offset1 + n - 1) + " with from " + offset2 + " to " + (offset2 + m - 1));
            System.out.println("s1=" + profile1.toString(offset1, n));
            System.out.println("s2=" + profile2.toString(offset2, m));
        }
        if (n < 6 || m < 6) {
            calculateResults = true;
            if (n > m) {
                invert = true;
                int temp = m;
                m = n;
                n = temp;
                temp = offset1;
                offset1 = offset2;
                offset2 = temp;
                startType = this.convertType(startType);
                endType = this.convertType(endType);
                Profile tempSequence = profile1;
                profile1 = profile2;
                profile2 = tempSequence;
            }
            this.allocateMatrices(n, m);
        }
        int u = n / 2;
        if (this.debug) {
            System.out.println(" u=" + u);
        }
        if (calculateResults) {
            int i = 1;
            while (i <= n) {
                this.Bk[1][i][0] = 1;
                this.Bi[1][i][0] = i - 1;
                this.Bj[1][i][0] = 0;
                ++i;
            }
        }
        int j = 1;
        while (j <= m) {
            base = this.d;
            if (startType == 2) {
                base = this.e;
            }
            Iy[0][j] = -base - this.e * (float)(j - 1);
            if (freeStartGap) {
                Iy[0][j] = 0.0f;
            }
            M[0][j] = Float.NEGATIVE_INFINITY;
            Ix[0][j] = Float.NEGATIVE_INFINITY;
            cy[0][j] = 0;
            cytype[0][j] = 2;
            if (calculateResults) {
                this.Bk[2][0][j] = 2;
                this.Bi[2][0][j] = 0;
                this.Bj[2][0][j] = j - 1;
            }
            ++j;
        }
        Iy[0][0] = Float.NEGATIVE_INFINITY;
        Ix[0][0] = Float.NEGATIVE_INFINITY;
        M[0][0] = 0.0f;
        cmtype[0][0] = 0;
        cm[0][0] = 0;
        NeedlemanWunschLinearSpaceAffine.swap01((Object[])Ix);
        NeedlemanWunschLinearSpaceAffine.swap01((Object[])Iy);
        NeedlemanWunschLinearSpaceAffine.swap01((Object[])M);
        NeedlemanWunschLinearSpaceAffine.swap01((Object[])cm);
        NeedlemanWunschLinearSpaceAffine.swap01((Object[])cx);
        NeedlemanWunschLinearSpaceAffine.swap01((Object[])cy);
        NeedlemanWunschLinearSpaceAffine.swap01((Object[])cmtype);
        NeedlemanWunschLinearSpaceAffine.swap01((Object[])cxtype);
        NeedlemanWunschLinearSpaceAffine.swap01((Object[])cytype);
        int i = 1;
        while (i <= n) {
            NeedlemanWunschLinearSpaceAffine.swap01((Object[])Ix);
            NeedlemanWunschLinearSpaceAffine.swap01((Object[])Iy);
            NeedlemanWunschLinearSpaceAffine.swap01((Object[])M);
            NeedlemanWunschLinearSpaceAffine.swap01((Object[])cm);
            NeedlemanWunschLinearSpaceAffine.swap01((Object[])cx);
            NeedlemanWunschLinearSpaceAffine.swap01((Object[])cy);
            NeedlemanWunschLinearSpaceAffine.swap01((Object[])cmtype);
            NeedlemanWunschLinearSpaceAffine.swap01((Object[])cxtype);
            NeedlemanWunschLinearSpaceAffine.swap01((Object[])cytype);
            M[1][0] = Float.NEGATIVE_INFINITY;
            Iy[1][0] = Float.NEGATIVE_INFINITY;
            base = this.d;
            if (startType == 1) {
                base = this.e;
            }
            Ix[1][0] = -base - this.e * (float)(i - 1);
            if (freeStartGap) {
                Ix[1][0] = 0.0f;
            }
            cxtype[1][0] = 1;
            cx[1][0] = 0;
            int j2 = 1;
            while (j2 <= m) {
                if (this.cancelled) {
                    return 0.0f;
                }
                float s = ProfileCharacter.score(profile1.profile[offset1 + i - 1], profile2.profile[offset2 + j2 - 1], this.sub);
                if (this.debug) {
                    System.out.println("loc=" + j2 + "," + i + " p1=" + profile1.profile[offset1 + i - 1] + " p2=" + profile2.profile[offset2 + j2 - 1] + " score=" + s);
                }
                float a = M[0][j2 - 1] + s;
                float b = Ix[0][j2 - 1] + s;
                float c = Iy[0][j2 - 1] + s;
                float f = NeedlemanWunschLinearSpaceAffine.max(a, b, c);
                M[1][j2] = f;
                float val = f;
                if (calculateResults) {
                    int k = 0;
                    if (val == b) {
                        k = 1;
                    }
                    if (val == c) {
                        k = 2;
                    }
                    this.Bi[0][i][j2] = i - 1;
                    this.Bj[0][i][j2] = j2 - 1;
                    this.Bk[0][i][j2] = k;
                }
                if (i == u) {
                    cm[1][j2] = j2;
                    cmtype[1][j2] = 0;
                } else if (i > u) {
                    if (val == a) {
                        cm[1][j2] = cm[0][j2 - 1];
                        cmtype[1][j2] = cmtype[0][j2 - 1];
                    } else if (val == b) {
                        cm[1][j2] = cx[0][j2 - 1];
                        cmtype[1][j2] = cxtype[0][j2 - 1];
                    } else if (val == c) {
                        cm[1][j2] = cy[0][j2 - 1];
                        cmtype[1][j2] = cytype[0][j2 - 1];
                    } else {
                        throw new Error("NWAffine 1");
                    }
                }
                float xd = this.d;
                float xe = this.e;
                if (j2 == m && freeEndGap) {
                    xd = 0.0f;
                    xe = 0.0f;
                }
                float gapFraction = NeedlemanWunschLinearSpaceAffine.gapFraction(profile1.profile[offset1 + i - 1]);
                float ownGapFraction = NeedlemanWunschLinearSpaceAffine.gapFraction(profile2.profile[offset2 + j2 - 1]);
                if (gapCostProduction && gapFraction > 0.0f) {
                    xd -= xe * gapFraction;
                    xe *= 1.0f - gapFraction;
                }
                a = M[0][j2] - xd;
                b = Ix[0][j2] - xe;
                c = Iy[0][j2] - xd;
                float f2 = NeedlemanWunschLinearSpaceAffine.max(a, b, c);
                Ix[1][j2] = f2;
                val = f2;
                if (calculateResults) {
                    int k = 0;
                    if (val == b) {
                        k = 1;
                    }
                    if (val == c) {
                        k = 2;
                    }
                    this.Bi[1][i][j2] = i - 1;
                    this.Bj[1][i][j2] = j2;
                    this.Bk[1][i][j2] = k;
                }
                if (i == u) {
                    cx[1][j2] = j2;
                    cxtype[1][j2] = 1;
                } else if (i > u) {
                    if (val == a) {
                        cx[1][j2] = cm[0][j2];
                        cxtype[1][j2] = cmtype[0][j2];
                    } else if (val == b) {
                        cx[1][j2] = cx[0][j2];
                        cxtype[1][j2] = cxtype[0][j2];
                    } else if (val == c) {
                        cx[1][j2] = cy[0][j2];
                        cxtype[1][j2] = cytype[0][j2];
                    } else {
                        throw new Error("NWAffine 2");
                    }
                }
                float yd = this.d;
                float ye = this.e;
                if (i == n && freeEndGap) {
                    yd = 0.0f;
                    ye = 0.0f;
                }
                ownGapFraction = NeedlemanWunschLinearSpaceAffine.gapFraction(profile1.profile[offset1 + i - 1]);
                gapFraction = NeedlemanWunschLinearSpaceAffine.gapFraction(profile2.profile[offset2 + j2 - 1]);
                if (gapCostProduction && gapFraction > 0.0f) {
                    yd -= ye * gapFraction;
                    ye *= 1.0f - gapFraction;
                }
                a = M[1][j2 - 1] - yd;
                b = Iy[1][j2 - 1] - ye;
                c = Ix[1][j2 - 1] - yd;
                float f3 = NeedlemanWunschLinearSpaceAffine.max(a, b, c);
                Iy[1][j2] = f3;
                val = f3;
                if (calculateResults) {
                    int k = 0;
                    if (val == b) {
                        k = 2;
                    }
                    if (val == c) {
                        k = 1;
                    }
                    this.Bi[2][i][j2] = i;
                    this.Bj[2][i][j2] = j2 - 1;
                    this.Bk[2][i][j2] = k;
                }
                if (i == u) {
                    cy[1][j2] = j2;
                    cytype[1][j2] = 2;
                } else if (i > u) {
                    if (val == a) {
                        cy[1][j2] = cm[1][j2 - 1];
                        cytype[1][j2] = cmtype[1][j2 - 1];
                    } else if (val == b) {
                        cy[1][j2] = cy[1][j2 - 1];
                        cytype[1][j2] = cytype[1][j2 - 1];
                    } else if (val == c) {
                        cy[1][j2] = cx[1][j2 - 1];
                        cytype[1][j2] = cxtype[1][j2 - 1];
                    } else {
                        throw new Error("NWAffine 3");
                    }
                }
                ++j2;
            }
            if (this.addProgress(m)) {
                return 0.0f;
            }
            ++i;
        }
        int bestk = 0;
        int k = 1;
        while (k < 3) {
            if (this.F[k][1][m] > this.F[bestk][1][m]) {
                bestk = k;
            }
            ++k;
        }
        if (endType == 1) {
            bestk = 1;
        }
        if (endType == 2) {
            bestk = 2;
        }
        assert (this.F[bestk][1][m] > Float.NEGATIVE_INFINITY);
        int v = this.C[bestk][1][m];
        int vtype = this.Ctype[bestk][1][m];
        if (this.debug) {
            System.out.println("bestk=" + bestk + " v=" + v + " vtype =" + vtype);
        }
        float finalScore = this.F[bestk][1][m];
        if (freeEndGap && n == 0) {
            finalScore = 0.0f;
        }
        if (freeStartGap && n == 0) {
            finalScore = 0.0f;
        }
        if (scoreOnly) {
            return finalScore;
        }
        if (calculateResults) {
            this.appendResults(invert, result1, result2, n, m, bestk);
        } else {
            boolean propagateFreeEndGap = freeEndGap && (u == n || v == m);
            boolean propagateFreeStartGap = freeStartGap && (u == 0 || v == 0);
            float score1 = this.doAlignment(profile1, profile2, offset1, offset2, u, v, startType, vtype, result1, result2, false, freeStartGap, propagateFreeEndGap);
            if (this.cancelled) {
                return 0.0f;
            }
            float score2 = this.doAlignment(profile1, profile2, offset1 + u, offset2 + v, n - u, m - v, vtype, endType, result1, result2, false, propagateFreeStartGap, freeEndGap);
            if (this.cancelled) {
                return 0.0f;
            }
            float combinedScore = score1 + score2;
            if (finalScore != 0.0f && (double)Math.abs((combinedScore - finalScore) / finalScore) > 1.0E-5 && profile1.sequenceCount == 1 && profile2.sequenceCount == 1) {
                System.out.println("free =" + freeStartGap + "," + freeEndGap);
                System.out.println("offset1=" + offset1 + " offset2=" + offset2 + " u=" + u + " v=" + v);
                System.out.println(score1 + "+" + score2 + "!=" + finalScore);
            }
        }
        return finalScore;
    }

    private void appendResults(boolean invert, AlignmentResult result1, AlignmentResult result2, int n, int m, int bestk) {
        StringBuilder res1 = new StringBuilder();
        StringBuilder res2 = new StringBuilder();
        int i = n;
        int j = m;
        int k = bestk;
        while (i != 0 || j != 0) {
            int tbi = this.Bi[k][i][j];
            int tbj = this.Bj[k][i][j];
            int tbk = this.Bk[k][i][j];
            if (i == tbi) {
                res1.append('-');
            } else {
                res1.append('X');
            }
            if (j == tbj) {
                res2.append('-');
            } else {
                res2.append('X');
            }
            i = tbi;
            j = tbj;
            k = tbk;
        }
        String string1 = res1.reverse().toString();
        String string2 = res2.reverse().toString();
        if (invert) {
            result1.append(string2);
            result2.append(string1);
        } else {
            result1.append(string1);
            result2.append(string2);
        }
    }

    public float getScore() {
        return this.resultScore;
    }

    public static void main(String[] arguments) {
        Scores scores = ScoresFactory.generateScores("Blosum45");
        String sequence1 = SequenceTester.getTestSequence1(arguments);
        String sequence2 = SequenceTester.getTestSequence2(arguments);
        sequence1 = "GTGGCAA---------AAAACATTCAAGCCATTCGCGGCATGAACGATTACCTGCCTGGCGAA---------------------ACGGCCATCTGGCAGCGCATTGAAGGCACACTGAAAAACGTGCTCGGCAGCTACGGTTACAGTGAAATCCGCTTGCCGATTGTAGAGCAGACCCCGCTATTCAAACGTGCGATTGGTGAAGTCACCGACGTGGTTGAAAAAGAGATGTACACCTTTGAGGATCGCAATGGCGACAG---CCTGACTCTGCGCCCTGAAGGGACGGCGGGCTGTGTACGCGCCGGCATCGAGCATGGTCTTCTGTACAAT---CAGGAACAGCGTCTGTGGTATATCGGGCCGATGTTCCGTCACGAGCGTCCGCAGAAAGGGCGTTATCGTCAGTTCCATCAGTTGGGCTGCGAAGTTTTCGGTCTGCAAGGTCCGGATATCGACGCTGAACTGATTATGCTCACTGCCCGCTGGTGGCGCGCGCTGGGTATTTCCGAGCACGTAACTCTTGAGCTGAACTCTATCGGTTCGCTGGAAGCACGCGCCAATTACCGCGATGCGCTGGTGGCATTCCTTGAGCAGCATAAAGAAAAGCTGGACGAAGACTGCAAACGCCGCATGTACACTAACCCGCTGCGCGTGCTGGATTCAAAAAATCCGGAAGTGCAGGCGCTTCTCAACGACGCTCCGGCATTAGGTGACTATCTGGACGAGG------------------------AATCTCGTGAGCATTTTGCCGGTCTGTGCAAACTGCTGGAGAGCGCGGGGAT---------------------------------------CGCTTACACCGTAAACCAGCGTCTGGTGCGTGGTCTGGATTACTACAACCGTACCGTTTTCGAGTGGGTGACTAACAGTCTCGGCTCCCAGGGCACCGTGTGTGCAGGCGGTCGTTATGACGGTCTTGTGGAACAACTGGGCGGTCGTGCAACACCGGCTGTCGGTTTTGCTATGGGCCTCGAACGTCTTGTATTGTTAGTACAGGCCGTTAATCCG---GAATTTAAAGCCGATCCTGTTGTCGATATATACCTGGTGGCTTCAGGTGCTGATACACAATCTGCGGCTATGGCATTAGCTGAGCGTCTGCGTGATGAATTACCGGGCGTGAAATTGATGACCAACCACGGCGGCGGCAACTTTAAGAAACAGTTTGCCCGTGCTGATAAATGGGGTGCCCGCGTTGCTGTGGTGCTGGGTGAGTCTGAAGTGGCTAACGGCACAGCAGTAGTGAAGGATTTGCGCTCTGGTGAGCAAACGGCAGTTGCGCAGGATAGCGTAGCCGCGCATTTGC--------------GCACGTT-------------------------------------------------------------------------ACTGGGTTAA";
        sequence1 = "GTGGCAAAAAACATTCAAGCCATTCGCGGCA";
        sequence2 = "GCCTGTCGCCCGACAACATCATCCTGTCGTGCAAGGTCAGCAATGTGCAGGACCTGATCAGCGTC";
        scores = new NucleotideScores(5.0f, -4.0f);
        float e = 0.1f;
        float d = 1.0f;
        System.out.println("aligning sequence of length " + sequence1.length() + " with sequence of length " + sequence2.length());
        boolean repeat = true;
        long start = System.currentTimeMillis();
        Object results2 = null;
        String[] results = null;
        String[] results3 = null;
        Object align2 = null;
        NeedlemanWunschLinearSpaceAffine align = null;
        OldNeedlemanWunschAffine align3 = null;
        long end = System.currentTimeMillis();
        System.out.println("quadratic space took " + (end - start) + " milliseconds");
        start = System.currentTimeMillis();
        int i = 0;
        while (i < 1) {
            align = new NeedlemanWunschLinearSpaceAffine(scores, d, e);
            align.doAlignment(sequence1, sequence2);
            results = align.getMatch();
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("linear space took " + (end - start) + " milliseconds");
        start = System.currentTimeMillis();
        i = 0;
        while (i < 1) {
            align3 = new OldNeedlemanWunschAffine(scores, d, e);
            align3.doAlignment(sequence1, sequence2);
            results3 = align3.getMatch();
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("old quadratic space took " + (end - start) + " milliseconds");
        System.out.println(results[0]);
        System.out.println(results3[0]);
        System.out.println(results[1]);
        System.out.println(results3[1]);
        float score = align.getScore();
        float score3 = align3.getScore();
        if (results[0].equals(results3[0]) && results[1].equals(results3[1])) {
            System.out.println("results are the same");
        } else {
            System.out.println("results are different");
        }
        System.out.println("score 1 =" + score);
        System.out.println("score 2 =" + score3);
        SmithWatermanLinearSpaceAffine align4 = null;
        start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 1) {
            align4 = new SmithWatermanLinearSpaceAffine(scores, d, e);
            align4.doAlignment(sequence1, sequence2);
            align4.getMatch();
            ++i2;
        }
        end = System.currentTimeMillis();
        System.out.println("SmithWaterman linear space affine space took " + (end - start) + " milliseconds");
    }

    public void setDebug(boolean display) {
        this.debug = display;
    }

    public PairwiseAligner.Result doAlignment(Sequence seq1, Sequence seq2, ProgressListener progress) {
        this.doAlignment(seq1.getString(), seq2.getString(), progress);
        if (progress.setProgress(1.0)) {
            return null;
        }
        ArrayList<BasicSequence> seqs = new ArrayList<BasicSequence>(2);
        String[] results = this.getMatch();
        seqs.add(new BasicSequence(seq1.getSequenceType(), seq1.getTaxon(), results[0]));
        seqs.add(new BasicSequence(seq2.getSequenceType(), seq2.getTaxon(), results[1]));
        return new PairwiseAligner.Result(new BasicAlignment(seqs), this.getScore());
    }

    public double getScore(Sequence seq1, Sequence seq2) {
        this.doAlignment(seq1.getString(), seq2.getString(), null, true);
        return this.getScore();
    }
}

