/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import java.util.ArrayList;
import java.util.Iterator;
import jebl.evolution.align.AlignRepeatAffine;
import jebl.evolution.align.LocalAlignment;
import jebl.evolution.align.Output;
import jebl.evolution.align.SmithWatermanLinearSpaceAffine;
import jebl.evolution.align.scores.Scores;

public class NonOverlapMultipleLocalAffine
extends AlignRepeatAffine {
    private ArrayList<LocalAlignment> localAligns = new ArrayList();
    private SmithWatermanLinearSpaceAffine swlsa;

    public NonOverlapMultipleLocalAffine(Scores sub, float d, float e, int T) {
        super(sub, d, e, T);
    }

    public void doAlignment(String sq1, String sq2) {
        if (sq1.length() < sq2.length()) {
            String temp = sq2;
            sq2 = sq1;
            sq1 = temp;
        }
        this.seq1 = sq1;
        this.seq2 = sq2;
        this.swlsa = new SmithWatermanLinearSpaceAffine(this.sub, this.d, this.e);
        this.swlsa.doAlignment(sq1, sq2);
        String[] match = this.swlsa.getMatch();
        if (this.swlsa.getScore() >= (float)this.T) {
            this.localAligns.add(new LocalAlignment(match[0], match[1], this.swlsa.start1, this.swlsa.end1 - 1, this.swlsa.getScore()));
            if (this.swlsa.start1 != 0) {
                this.recurseAlignment(sq1.substring(0, this.swlsa.start1), 0);
            }
            if (this.swlsa.end1 != sq1.length()) {
                this.recurseAlignment(sq1.substring(this.swlsa.end1, sq1.length()), this.swlsa.end1);
            }
        }
    }

    public void recurseAlignment(String sq1, int leftIndex) {
        this.swlsa.doAlignment(sq1, this.seq2);
        String[] match = this.swlsa.getMatch();
        if (!(this.swlsa.getScore() >= (float)this.T)) {
            return;
        }
        this.localAligns.add(new LocalAlignment(match[0], match[1], this.swlsa.start1 + leftIndex, this.swlsa.end1 - 1 + leftIndex, this.swlsa.getScore()));
        if (this.swlsa.start1 != 0) {
            this.recurseAlignment(sq1.substring(0, this.swlsa.start1), leftIndex);
        }
        if (this.swlsa.end1 != sq1.length()) {
            this.recurseAlignment(sq1.substring(this.swlsa.end1, sq1.length()), leftIndex + this.swlsa.end1);
        }
    }

    public String[] getMatch() {
        String sq1 = "";
        String sq2 = "";
        for (LocalAlignment localAlign : this.localAligns) {
            sq1 = String.valueOf(sq1) + localAlign.sq1 + " - ";
            sq2 = String.valueOf(sq2) + localAlign.sq2 + " - ";
        }
        return new String[]{sq1.substring(0, sq1.length() - 3), sq2.substring(0, sq1.length() - 3)};
    }

    public String getMatchScores(int width) {
        String matchScores = "";
        for (LocalAlignment la : this.localAligns) {
            String sq1 = la.sq1;
            String sq2 = la.sq2;
            float score = la.score;
            if (la.sq1.length() < width) {
                matchScores = String.valueOf(matchScores) + "Score: " + score + "\n";
                matchScores = String.valueOf(matchScores) + sq1 + "\n";
                matchScores = String.valueOf(matchScores) + sq1 + "\n\n\n";
                continue;
            }
            matchScores = String.valueOf(matchScores) + "Score: " + score + "\n";
            int size = sq1.length();
            int i = width;
            while (i < size + width) {
                if (i > size) {
                    matchScores = String.valueOf(matchScores) + sq1.substring(i - width, size) + "\n";
                    matchScores = String.valueOf(matchScores) + sq2.substring(i - width, size) + "\n\n";
                } else {
                    matchScores = String.valueOf(matchScores) + sq1.substring(i - width, i) + "\n";
                    matchScores = String.valueOf(matchScores) + sq2.substring(i - width, i) + "\n\n";
                }
                i += width;
            }
            matchScores = String.valueOf(matchScores) + "\n";
        }
        return matchScores;
    }

    public float getScore() {
        float score = 0.0f;
        for (LocalAlignment la : this.localAligns) {
            score += la.score;
        }
        return score;
    }

    public float[] getScores() {
        float[] scores = new float[this.localAligns.size()];
        int i = 0;
        for (LocalAlignment la : this.localAligns) {
            scores[i] = la.score;
            ++i;
        }
        return scores;
    }

    public String[][] getAlignments() {
        String[][] aligns = new String[this.localAligns.size()][2];
        int i = 0;
        Iterator<LocalAlignment> iterator = this.localAligns.iterator();
        while (iterator.hasNext()) {
            LocalAlignment localAlign;
            LocalAlignment la = localAlign = iterator.next();
            aligns[i][0] = la.sq1;
            aligns[i][2] = la.sq2;
            ++i;
        }
        return aligns;
    }

    public void printf(Output out) {
        this.swlsa.printf(out);
    }
}

