/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import jebl.evolution.align.scores.Scores;

public class ProfileCharacter {
    private final char[] characters;
    private final int[] count;
    private int numberOfUniqueCharacters;
    private int totalCharacters;
    private boolean calculatedGapFraction = false;
    private float gapFraction;
    private boolean isImmutable = false;
    private static int MAX_CHAR = 128;
    private static ProfileCharacter[] immutableCharacters = new ProfileCharacter[MAX_CHAR];

    static {
        char c = '\u0000';
        while (c < MAX_CHAR) {
            ProfileCharacter.immutableCharacters[c] = ProfileCharacter.createImmutableProfileCharacter(c);
            c = (char)(c + '\u0001');
        }
    }

    public ProfileCharacter(int alphabetSize) {
        if (alphabetSize < 0) {
            throw new IllegalArgumentException("Expected a nonnegative alphabet size, got " + alphabetSize);
        }
        this.characters = new char[alphabetSize + 1];
        this.count = new int[alphabetSize + 1];
    }

    private static ProfileCharacter createImmutableProfileCharacter(char c) {
        ProfileCharacter pc = new ProfileCharacter(0);
        pc.totalCharacters = 1;
        pc.characters[0] = c;
        pc.count[0] = 1;
        pc.totalCharacters = 1;
        pc.numberOfUniqueCharacters = 1;
        pc.gapFraction();
        return pc;
    }

    public static ProfileCharacter getImmutableProfileCharacter(char character) {
        if (character >= '\u0000' && character < MAX_CHAR) {
            return immutableCharacters[character];
        }
        return ProfileCharacter.createImmutableProfileCharacter(character);
    }

    private void assertMutable() {
        if (this.isImmutable) {
            throw new IllegalArgumentException("This profile is immutable");
        }
    }

    public void addCharacter(char character, int increment) {
        this.assertMutable();
        this.calculatedGapFraction = false;
        this.totalCharacters += increment;
        int i = 0;
        while (i < this.numberOfUniqueCharacters) {
            if (this.characters[i] == character) {
                int n = i;
                this.count[n] = this.count[n] + increment;
                return;
            }
            ++i;
        }
        this.characters[this.numberOfUniqueCharacters] = character;
        this.count[this.numberOfUniqueCharacters++] = increment;
    }

    private void removeCharacter(char character, int increment) {
        this.assertMutable();
        this.calculatedGapFraction = false;
        this.totalCharacters -= increment;
        int i = 0;
        while (i < this.numberOfUniqueCharacters) {
            if (this.characters[i] == character) {
                int n = i;
                this.count[n] = this.count[n] - increment;
                if (this.count[i] == 0) {
                    this.count[i] = this.count[this.numberOfUniqueCharacters - 1];
                    this.characters[i] = this.characters[this.numberOfUniqueCharacters - 1];
                    --this.numberOfUniqueCharacters;
                }
                return;
            }
            ++i;
        }
        assert (false);
    }

    public void addProfileCharacter(ProfileCharacter character) {
        this.assertMutable();
        int j = 0;
        while (j < character.numberOfUniqueCharacters) {
            this.addCharacter(character.characters[j], character.count[j]);
            ++j;
        }
    }

    public void removeProfileCharacter(ProfileCharacter character) {
        this.assertMutable();
        int j = 0;
        while (j < character.numberOfUniqueCharacters) {
            this.removeCharacter(character.characters[j], character.count[j]);
            ++j;
        }
    }

    public void addGaps(int count) {
        this.assertMutable();
        this.addCharacter('-', count);
    }

    public static float score(ProfileCharacter character1, ProfileCharacter character2, Scores scores) {
        float score = 0.0f;
        int totalCharacters = character1.totalCharacters * character2.totalCharacters;
        if (totalCharacters == 1) {
            return scores.score[character1.characters[0]][character2.characters[0]];
        }
        int i = 0;
        while (i < character1.numberOfUniqueCharacters) {
            int j = 0;
            while (j < character2.numberOfUniqueCharacters) {
                char char1 = character1.characters[i];
                char char2 = character2.characters[j];
                int count = character1.count[i] * character2.count[j];
                score += scores.score[char1][char2] * (float)count;
                ++j;
            }
            ++i;
        }
        return score / (float)totalCharacters;
    }

    public static float scoreSelf(ProfileCharacter character, Scores scores) {
        float score = 0.0f;
        long totalCharacters = (long)character.totalCharacters * (long)character.totalCharacters;
        if (totalCharacters == 1L) {
            return scores.score[character.characters[0]][character.characters[0]];
        }
        int i = 0;
        while (i < character.numberOfUniqueCharacters) {
            int j = 0;
            while (j < character.numberOfUniqueCharacters) {
                score += scores.score[character.characters[i]][character.characters[j]] * (float)character.count[i] * (float)character.count[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < character.numberOfUniqueCharacters) {
            score -= scores.score[character.characters[i]][character.characters[i]];
            --totalCharacters;
            ++i;
        }
        return score / (float)totalCharacters;
    }

    public int print() {
        System.out.print(this.toString());
        return this.numberOfUniqueCharacters;
    }

    public String toString() {
        if (this.numberOfUniqueCharacters == 1) {
            return "" + this.characters[0];
        }
        StringBuilder result = new StringBuilder();
        result.append("(");
        int i = 0;
        while (i < this.numberOfUniqueCharacters) {
            result.append(String.format("%c: %d ", Character.valueOf(this.characters[i]), this.count[i]));
            ++i;
        }
        result.append(")");
        return result.toString();
    }

    public boolean isAllGaps() {
        if (this.numberOfUniqueCharacters > 2) {
            return false;
        }
        if (this.characters[0] != '-' && this.characters[0] != '_') {
            return false;
        }
        if (this.numberOfUniqueCharacters == 1) {
            return true;
        }
        return this.characters[1] == '-' || this.characters[1] == '_';
    }

    public void clear() {
        this.assertMutable();
        this.numberOfUniqueCharacters = 0;
        this.totalCharacters = 0;
    }

    public float gapFraction() {
        if (this.totalCharacters == 0) {
            return 0.0f;
        }
        if (this.calculatedGapFraction) {
            return this.gapFraction;
        }
        int gapCount = 0;
        int i = 0;
        while (i < this.numberOfUniqueCharacters) {
            if (this.characters[i] == '-' || this.characters[i] == '_') {
                gapCount += this.count[i];
            }
            ++i;
        }
        this.gapFraction = (float)gapCount / (float)this.totalCharacters;
        assert (this.gapFraction >= 0.0f);
        return this.gapFraction;
    }
}

