/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import java.util.Random;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import jebl.evolution.align.Align;

public class SequenceShuffler {
    private float max;
    private float min;
    private float mean;
    private float variance;
    private ProgressMonitor monitor = null;
    private static Random random = new Random();

    public void shuffle(Align algorithm, String sq1, String sq2, int numShuffles) {
        if (this.monitor != null) {
            this.monitor.setMinimum(0);
            this.monitor.setMaximum(numShuffles);
        }
        float[] scores = new float[numShuffles];
        float sumScores = 0.0f;
        int i = 0;
        while (i < numShuffles) {
            String shuffled2 = this.shuffleSeq(sq2);
            algorithm.doAlignment(sq1, shuffled2);
            scores[i] = algorithm.getScore();
            sumScores += algorithm.getScore();
            final int j = i;
            if (this.monitor != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        SequenceShuffler.this.monitor.setProgress(j);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
            ++i;
        }
        if (this.monitor != null) {
            this.monitor.setProgress(this.monitor.getMaximum());
        }
        this.mean = sumScores / (float)numShuffles;
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
        float sqDiffSum = 0.0f;
        int i2 = 0;
        while (i2 < numShuffles) {
            sqDiffSum = (float)((double)sqDiffSum + Math.pow(scores[i2] - this.mean, 2.0));
            if (scores[i2] < this.min) {
                this.min = scores[i2];
            }
            if (scores[i2] > this.max) {
                this.max = scores[i2];
            }
            ++i2;
        }
        this.variance = sqDiffSum / (float)numShuffles;
    }

    private String shuffleSeq(String s) {
        char[] a = s.toCharArray();
        int i = 0;
        while (i < a.length - 1) {
            int r = random.nextInt(a.length - i - 1) + 1;
            char swap = a[r];
            a[r] = a[i];
            a[i] = swap;
            ++i;
        }
        return String.valueOf(a);
    }

    public float getMean() {
        return this.mean;
    }

    public float getMax() {
        return this.max;
    }

    public float getMin() {
        return this.min;
    }

    public double getStdev() {
        return Math.sqrt(this.variance);
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

