/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import jebl.evolution.align.AlignLinearSpaceAffine;
import jebl.evolution.align.NeedlemanWunschAffine;
import jebl.evolution.align.NeedlemanWunschLinearSpaceAffine;
import jebl.evolution.align.TracebackPlotter;
import jebl.evolution.align.TracebackSimple;
import jebl.evolution.align.scores.Scores;
import jebl.util.ProgressListener;

public class SmithWatermanLinearSpaceAffine
extends AlignLinearSpaceAffine {
    TracebackSimple[][] start;
    float maxval;
    int start1;
    int start2;
    int end1;
    int end2;

    public SmithWatermanLinearSpaceAffine(Scores sub, float d, float e) {
        super(sub, d, e);
    }

    public void doAlignment(String sq1, String sq2, ProgressListener progress) {
        this.prepareAlignment(sq1, sq2);
        char[] s1 = sq1.toCharArray();
        char[] s2 = sq2.toCharArray();
        int n = this.n;
        int m = this.m;
        float[][] score = this.sub.score;
        float[][] M = this.F[0];
        float[][] Ix = this.F[1];
        float[][] Iy = this.F[2];
        this.start = new TracebackSimple[2][m + 1];
        this.maxval = Float.NEGATIVE_INFINITY;
        int j = 0;
        while (j <= m) {
            this.start[1][j] = new TracebackSimple(0, j);
            ++j;
        }
        int i = 1;
        while (i <= n) {
            if (progress != null && progress.setProgress((double)i / (double)n)) {
                return;
            }
            SmithWatermanLinearSpaceAffine.swap01((Object[])M);
            SmithWatermanLinearSpaceAffine.swap01((Object[])Ix);
            SmithWatermanLinearSpaceAffine.swap01((Object[])Iy);
            SmithWatermanLinearSpaceAffine.swap01((Object[])this.start);
            this.start[1][0] = new TracebackSimple(i, 0);
            int j2 = 1;
            while (j2 <= m) {
                float valiy;
                float valix;
                float s = score[s1[i - 1]][s2[j2 - 1]];
                M[1][j2] = SmithWatermanLinearSpaceAffine.max(0.0f, M[0][j2 - 1] + s, Ix[0][j2 - 1] + s, Iy[0][j2 - 1] + s);
                float valm = M[1][j2];
                float val = SmithWatermanLinearSpaceAffine.max(valm, valix = (Ix[1][j2] = SmithWatermanLinearSpaceAffine.max(M[0][j2] - this.d, Ix[0][j2] - this.e)), valiy = (Iy[1][j2] = SmithWatermanLinearSpaceAffine.max(M[1][j2 - 1] - this.d, Iy[1][j2 - 1] - this.e)));
                if (val == 0.0f) {
                    this.start[1][j2] = new TracebackSimple(i, j2);
                } else if (val == valm) {
                    this.start[1][j2] = this.start[0][j2 - 1];
                } else if (val == valix) {
                    this.start[1][j2] = this.start[0][j2];
                } else if (val == valiy) {
                    this.start[1][j2] = this.start[1][j2 - 1];
                } else {
                    throw new Error("SWSmartAffine 1");
                }
                if (val > this.maxval) {
                    this.maxval = val;
                    TracebackSimple sij = this.start[1][j2];
                    this.start1 = sij.i;
                    this.start2 = sij.j;
                    this.end1 = i;
                    this.end2 = j2;
                }
                ++j2;
            }
            ++i;
        }
    }

    public void doAlignment(String sequence1, String sequence2) {
        this.doAlignment(sequence1, sequence2, null);
    }

    public float getScore() {
        return this.maxval;
    }

    public String[] getMatch() {
        String subseq1 = this.seq1.substring(this.start1, this.end1);
        String subseq2 = this.seq2.substring(this.start2, this.end2);
        NeedlemanWunschLinearSpaceAffine nwa1 = new NeedlemanWunschLinearSpaceAffine(this.sub, this.d, this.e);
        nwa1.doAlignment(subseq1, subseq2);
        return nwa1.getMatch();
    }

    public void traceback(TracebackPlotter plotter) {
        String subseq1 = this.seq1.substring(this.start1, this.end1);
        String subseq2 = this.seq2.substring(this.start2, this.end2);
        NeedlemanWunschAffine nwa1 = new NeedlemanWunschAffine(this.sub, this.d, this.e);
        nwa1.doAlignment(subseq1, subseq2);
        nwa1.traceback(plotter);
    }
}

