/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align.scores;

import java.util.ArrayList;
import jebl.evolution.align.scores.Scores;
import jebl.evolution.sequences.NucleotideState;
import jebl.evolution.sequences.Nucleotides;

public class NucleotideScores
extends Scores {
    float match = 5.0f;
    float mismatchTransition = -4.0f;
    float mismatchTransversion = -4.0f;
    String name = "";
    private boolean includeAmbiguities;
    private String alphabet = String.valueOf(Nucleotides.CANONICAL_STATES[0].getCode()) + Nucleotides.CANONICAL_STATES[1].getCode() + Nucleotides.CANONICAL_STATES[2].getCode() + Nucleotides.CANONICAL_STATES[3].getCode() + "U";
    public static final NucleotideScores IUB = new NucleotideScores(1.0f, -0.9f);
    public static final NucleotideScores CLUSTALW = new NucleotideScores(1.0f, 0.0f);

    protected NucleotideScores() {
    }

    public NucleotideScores(NucleotideScores scores) {
        this.name = scores.name;
        this.alphabet = scores.getAlphabet();
        this.match = scores.match;
        this.mismatchTransition = scores.mismatchTransition;
        this.mismatchTransversion = scores.mismatchTransversion;
    }

    public NucleotideScores(float match, float misMatch) {
        this("", match, misMatch);
    }

    public NucleotideScores(float match, float misMatch, float ambiguousMatch) {
        this("", match, misMatch, misMatch, ambiguousMatch, false);
    }

    public NucleotideScores(String name, float match, float misMatch) {
        this(name, match, misMatch, misMatch, 0.0f, true);
    }

    public NucleotideScores(String name, float match, float mismatchTransition, float mismatchTransversion) {
        this.name = name;
        this.buildScores(match, mismatchTransition, mismatchTransversion, 0.0f, false);
    }

    public NucleotideScores(String name, float match, float mismatchTransition, float mismatchTransversion, float ambiguousMatch, boolean useWeightedAmbigousMatches) {
        this.name = name;
        this.buildScores(match, mismatchTransition, mismatchTransversion, ambiguousMatch, true, useWeightedAmbigousMatches);
    }

    public NucleotideScores(Scores scores, double percentmatches) {
        double match = Math.log(percentmatches / 0.25);
        double mismatch = Math.log((1.0 - percentmatches) / 0.75);
        float ma = scores.score[65][65];
        float mm = (float)(mismatch * ((double)ma / match));
        this.name = String.valueOf((int)Math.round(100.0 * percentmatches)) + "% similarity";
        this.buildScores(ma, mm, mm, 0.0f, true);
        NucleotideScores.includeAdditionalCharacters(this, scores.getExtraResidues());
    }

    void buildScores(float match, float mismatchTransition, float mismatchTransversion, float ambiguousMatch, boolean includeAmbiguities) {
        this.buildScores(match, mismatchTransition, mismatchTransversion, ambiguousMatch, includeAmbiguities, false);
    }

    void buildScores(float match, float mismatchTransition, float mismatchTransversion, float ambiguousMatch, boolean includeAmbiguities, boolean useWeightedAmbigousMatches) {
        this.match = match;
        this.mismatchTransition = mismatchTransition;
        this.mismatchTransversion = mismatchTransversion;
        this.includeAmbiguities = includeAmbiguities;
        ArrayList<NucleotideState> states = new ArrayList<NucleotideState>();
        StringBuilder builder = new StringBuilder();
        NucleotideState[] nucleotideStateArray = Nucleotides.STATES;
        int n = Nucleotides.STATES.length;
        int n2 = 0;
        while (n2 < n) {
            NucleotideState state = nucleotideStateArray[n2];
            if (!(state.isGap() || state.isAmbiguous() && !includeAmbiguities)) {
                states.add(state);
                builder.append(state.getCode());
            }
            ++n2;
        }
        this.alphabet = String.valueOf(builder.toString()) + "U";
        states.add(Nucleotides.T_STATE);
        int statesCount = states.size();
        float[][] scores = new float[statesCount][statesCount];
        int i = 0;
        while (i < statesCount) {
            NucleotideState state1 = (NucleotideState)states.get(i);
            int j = 0;
            while (j < statesCount) {
                float value;
                NucleotideState state2 = (NucleotideState)states.get(j);
                if (state1.equals(state2) && !useWeightedAmbigousMatches) {
                    value = match;
                } else if (state1.possiblyEqual(state2)) {
                    if (useWeightedAmbigousMatches) {
                        float min = Math.min(mismatchTransition, mismatchTransversion);
                        value = (float)((double)min + state1.fractionEqual(state2) * (double)(match - min));
                    } else {
                        value = ambiguousMatch;
                    }
                } else {
                    value = Nucleotides.isPurine(state1) && Nucleotides.isPurine(state2) || Nucleotides.isPyrimidine(state1) && Nucleotides.isPyrimidine(state2) ? mismatchTransition : mismatchTransversion;
                }
                scores[i][j] = value;
                ++j;
            }
            ++i;
        }
        this.buildScores(scores);
    }

    public String getName() {
        return this.name;
    }

    public final String getAlphabet() {
        return String.valueOf(this.alphabet) + this.getExtraResidues();
    }

    public String toString() {
        String result = String.valueOf(this.match) + "/" + this.mismatchTransition;
        if (this.mismatchTransversion != this.mismatchTransition) {
            result = String.valueOf(result) + "/" + this.mismatchTransversion;
        }
        if (this.name.length() > 0) {
            result = String.valueOf(this.name) + " (" + result + ")";
        }
        return result;
    }
}

