/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.alignments;

import java.util.List;
import java.util.Set;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.alignments.BasicAlignment;
import jebl.evolution.alignments.Pattern;
import jebl.evolution.sequences.BasicSequence;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.taxa.Taxon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResampledAlignment
implements Alignment {
    protected BasicAlignment alignment;

    public void init(Alignment srcAlignment, int[] siteIndices) {
        int nNewSites = siteIndices.length;
        int nSeqs = srcAlignment.getSequences().size();
        State[][] newSeqsStates = new State[nSeqs][];
        int k = 0;
        while (k < nSeqs) {
            newSeqsStates[k] = new State[nNewSites];
            ++k;
        }
        List<Sequence> seqs = srcAlignment.getSequenceList();
        int n = 0;
        while (n < nNewSites) {
            int fromSite = siteIndices[n];
            int k2 = 0;
            while (k2 < nSeqs) {
                newSeqsStates[k2][n] = seqs.get(k2).getState(fromSite);
                ++k2;
            }
            ++n;
        }
        Sequence[] newSeqs = new Sequence[nSeqs];
        int k3 = 0;
        while (k3 < nSeqs) {
            Sequence src = seqs.get(k3);
            newSeqs[k3] = new BasicSequence(src.getSequenceType(), src.getTaxon(), newSeqsStates[k3]);
            ++k3;
        }
        this.alignment = new BasicAlignment(newSeqs);
    }

    @Override
    public List<Sequence> getSequenceList() {
        return this.alignment.getSequenceList();
    }

    @Override
    public int getPatternCount() {
        return this.alignment.getPatternCount();
    }

    @Override
    public int getPatternLength() {
        return this.alignment.getPatternLength();
    }

    @Override
    public List<Pattern> getPatterns() {
        return this.alignment.getPatterns();
    }

    @Override
    public List<Taxon> getTaxa() {
        return this.alignment.getTaxa();
    }

    @Override
    public SequenceType getSequenceType() {
        return this.alignment.getSequenceType();
    }

    @Override
    public int getSiteCount() {
        return this.alignment.getSiteCount();
    }

    @Override
    public Set<Sequence> getSequences() {
        return this.alignment.getSequences();
    }

    @Override
    public Sequence getSequence(Taxon taxon) {
        return this.alignment.getSequence(taxon);
    }
}

