/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.ImportHelper;
import jebl.evolution.io.SequenceImporter;
import jebl.evolution.sequences.BasicSequence;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.taxa.Taxon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhylipSequentialImporter
implements SequenceImporter {
    private final ImportHelper helper;
    private final SequenceType sequenceType;
    private int maxNameLength = 10;

    public PhylipSequentialImporter(Reader reader, SequenceType sequenceType, int maxNameLength) {
        this.helper = new ImportHelper(reader);
        this.sequenceType = sequenceType;
        this.maxNameLength = maxNameLength;
    }

    @Override
    public List<Sequence> importSequences() throws IOException, ImportException {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        try {
            int taxonCount = this.helper.readInteger();
            int siteCount = this.helper.readInteger();
            String firstSeq = null;
            int i = 0;
            while (i < taxonCount) {
                StringBuilder name = new StringBuilder();
                char ch = this.helper.read();
                int n = 0;
                while (!(Character.isWhitespace(ch) || this.maxNameLength >= 1 && n >= this.maxNameLength)) {
                    name.append(ch);
                    ch = this.helper.read();
                    ++n;
                }
                StringBuilder seq = new StringBuilder(siteCount);
                this.helper.readSequence(seq, this.sequenceType, "", siteCount, "-", "?", ".", firstSeq);
                if (firstSeq == null) {
                    firstSeq = seq.toString();
                }
                sequences.add(new BasicSequence(this.sequenceType, Taxon.getTaxon(name.toString()), seq.toString()));
                ++i;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return sequences;
    }
}

