/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.parsimony;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jebl.evolution.alignments.Pattern;
import jebl.evolution.alignments.Patterns;
import jebl.evolution.graphs.Node;
import jebl.evolution.parsimony.ParsimonyCriterion;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitchParsimony
implements ParsimonyCriterion {
    private final SequenceType sequenceType;
    private final int stateCount;
    private final boolean gapsAreStates;
    private Map<Node, boolean[][]> stateSets = new HashMap<Node, boolean[][]>();
    private Map<Node, State[]> states = new HashMap<Node, State[]>();
    private RootedTree tree = null;
    private final List<Pattern> patterns;
    private List<Taxon> taxa;
    private boolean hasCalculatedSteps = false;
    private boolean hasRecontructedStates = false;
    private final double[] siteScores;

    public FitchParsimony(List<Pattern> patterns, boolean gapsAreStates) {
        if (patterns == null || patterns.size() == 0) {
            throw new IllegalArgumentException("The patterns cannot be null or empty");
        }
        this.sequenceType = patterns.get(0).getSequenceType();
        this.gapsAreStates = gapsAreStates;
        this.taxa = patterns.get(0).getTaxa();
        this.stateCount = gapsAreStates ? this.sequenceType.getCanonicalStateCount() + 1 : this.sequenceType.getCanonicalStateCount();
        this.patterns = patterns;
        this.siteScores = new double[patterns.size()];
    }

    public FitchParsimony(Patterns patterns, boolean gapsAreStates) {
        this(patterns.getPatterns(), gapsAreStates);
    }

    @Override
    public double[] getSiteScores(Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("The tree cannot be null");
        }
        if (!(tree instanceof RootedTree)) {
            throw new IllegalArgumentException("The tree must be an instance of rooted tree");
        }
        if (this.tree == null || this.tree != tree) {
            this.tree = (RootedTree)tree;
            if (!Utils.isBinary(this.tree)) {
                throw new IllegalArgumentException("The Fitch algorithm can only reconstruct ancestral states on binary trees");
            }
            this.initialize();
        }
        if (!this.hasCalculatedSteps) {
            int i = 0;
            while (i < this.siteScores.length) {
                this.siteScores[i] = 0.0;
                ++i;
            }
            this.calculateSteps(this.tree);
            this.hasCalculatedSteps = true;
        }
        return this.siteScores;
    }

    @Override
    public double getScore(Tree tree) {
        this.getSiteScores(tree);
        double score = 0.0;
        int i = 0;
        for (Pattern pattern : this.patterns) {
            score += this.siteScores[i] * pattern.getWeight();
            ++i;
        }
        return score;
    }

    @Override
    public State[] getStates(Tree tree, Node node) {
        this.getSiteScores(tree);
        if (!this.hasRecontructedStates) {
            this.reconstructStates(this.tree.getRootNode(), null);
            this.hasRecontructedStates = true;
        }
        return this.states.get(node);
    }

    private void initialize() {
        this.hasCalculatedSteps = false;
        this.hasRecontructedStates = false;
        for (Node node : this.tree.getNodes()) {
            boolean[][] stateSet = new boolean[this.patterns.size()][this.stateCount];
            this.stateSets.put(node, stateSet);
            State[] stateArray = new State[this.patterns.size()];
            this.states.put(node, stateArray);
        }
    }

    private void calculateSteps(RootedTree tree) {
        List<Node> nodes = Utils.getNodes(tree, tree.getRootNode());
        boolean[][] union = new boolean[this.patterns.size()][this.stateCount];
        boolean[][] intersection = new boolean[this.patterns.size()][this.stateCount];
        int k = nodes.size() - 1;
        while (k >= 0) {
            Node node = nodes.get(k);
            boolean[][] nodeStateSet = this.stateSets.get(node);
            if (tree.isExternal(node)) {
                boolean[][] stateSet = this.stateSets.get(node);
                State[] stateArray = this.states.get(node);
                int i = 0;
                while (i < this.patterns.size()) {
                    State state;
                    Pattern pattern = this.patterns.get(i);
                    Taxon taxon = tree.getTaxon(node);
                    int index = this.taxa.indexOf(taxon);
                    if (index == -1) {
                        throw new IllegalArgumentException("Unknown taxon, " + taxon.getName() + " in tree");
                    }
                    stateArray[i] = state = pattern.getState(index);
                    if (this.gapsAreStates && state.isGap()) {
                        stateSet[i][this.stateCount - 1] = true;
                    } else {
                        for (State canonicalState : state.getCanonicalStates()) {
                            stateSet[i][canonicalState.getIndex()] = true;
                        }
                    }
                    ++i;
                }
            } else {
                boolean first = true;
                for (Node child : tree.getChildren(node)) {
                    int i;
                    boolean[][] childStateSet = this.stateSets.get(child);
                    if (first) {
                        i = 0;
                        while (i < this.patterns.size()) {
                            FitchParsimony.copyOf(childStateSet[i], union[i]);
                            FitchParsimony.copyOf(childStateSet[i], intersection[i]);
                            ++i;
                        }
                        first = false;
                        continue;
                    }
                    i = 0;
                    while (i < this.patterns.size()) {
                        FitchParsimony.unionOf(union[i], childStateSet[i], union[i]);
                        FitchParsimony.intersectionOf(intersection[i], childStateSet[i], intersection[i]);
                        ++i;
                    }
                }
                int i = 0;
                while (i < this.patterns.size()) {
                    if (FitchParsimony.sizeOf(intersection[i]) > 0) {
                        FitchParsimony.copyOf(intersection[i], nodeStateSet[i]);
                    } else {
                        FitchParsimony.copyOf(union[i], nodeStateSet[i]);
                        int n = i;
                        this.siteScores[n] = this.siteScores[n] + 1.0;
                    }
                    ++i;
                }
            }
            --k;
        }
    }

    private String printState(boolean[][] stateSet) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int n = stateSet.length;
        while (i < n) {
            sb.append("site " + i);
            int j = 0;
            int l = stateSet[i].length;
            while (j < l) {
                sb.append(" " + (stateSet[i][j] ? "T" : "F"));
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    private String printState(boolean[] stateSet) {
        StringBuffer sb = new StringBuffer();
        int j = 0;
        int l = stateSet.length;
        while (j < l) {
            sb.append(" " + (stateSet[j] ? "T" : "F"));
            ++j;
        }
        return sb.toString();
    }

    private void reconstructStates(Node node, State[] parentStates) {
        if (!this.tree.isExternal(node)) {
            boolean[][] nodeStateSet = this.stateSets.get(node);
            State[] nodeStates = this.states.get(node);
            int i = 0;
            while (i < this.patterns.size()) {
                if (parentStates != null && nodeStateSet[i][parentStates[i].getIndex()]) {
                    nodeStates[i] = parentStates[i];
                } else {
                    int first = FitchParsimony.firstIndexOf(nodeStateSet[i]);
                    nodeStates[i] = this.sequenceType.getState(first);
                }
                ++i;
            }
            for (Node child : this.tree.getChildren(node)) {
                this.reconstructStates(child, nodeStates);
            }
        }
    }

    private static void copyOf(boolean[] s, boolean[] d) {
        int i = 0;
        while (i < d.length) {
            d[i] = s[i];
            ++i;
        }
    }

    private static void unionOf(boolean[] s1, boolean[] s2, boolean[] d) {
        int i = 0;
        while (i < d.length) {
            d[i] = s1[i] || s2[i];
            ++i;
        }
    }

    private static void intersectionOf(boolean[] s1, boolean[] s2, boolean[] d) {
        int i = 0;
        while (i < d.length) {
            d[i] = s1[i] && s2[i];
            ++i;
        }
    }

    private static int firstIndexOf(boolean[] s1) {
        int i = 0;
        while (i < s1.length) {
            if (s1[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int sizeOf(boolean[] s1) {
        int count = 0;
        int i = 0;
        while (i < s1.length) {
            if (s1[i]) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

