/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jebl.evolution.sequences.AminoAcidState;
import jebl.evolution.sequences.AminoAcids;
import jebl.evolution.sequences.CodonState;
import jebl.evolution.sequences.Codons;
import jebl.evolution.sequences.NucleotideState;
import jebl.evolution.sequences.Nucleotides;
import jebl.evolution.sequences.State;
import jebl.util.MaybeBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneticCode {
    private final Map<CodonState, AminoAcidState> translationMap;
    private static final CodonState DEFAULT_START_CODON = Codons.getState("ATG");
    private static final Set<CodonState> DEFAULT_START_CODONS = Collections.singleton(DEFAULT_START_CODON);
    public static final GeneticCode UNIVERSAL = new GeneticCode("universal", "Standard", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSS*CWCLFLF", 1);
    public static final GeneticCode VERTEBRATE_MT = new GeneticCode("vertebrateMitochondrial", "Vertebrate Mitochondrial", "KNKNTTTT*S*SMIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", 2);
    public static final GeneticCode YEAST = new GeneticCode("yeast", "Yeast Mitochondrial", "KNKNTTTTRSRSMIMIQHQHPPPPRRRRTTTTEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", 3);
    public static final GeneticCode MOLD_PROTOZOAN_MT = new GeneticCode("moldProtozoanMitochondrial", "Mold Protozoan Mitochondrial", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", 4);
    public static final GeneticCode MYCOPLASMA = new GeneticCode("mycoplasma", "Mycoplasma", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF");
    public static final GeneticCode INVERTEBRATE_MT = new GeneticCode("invertebrateMitochondrial", "Invertebrate Mitochondrial", "KNKNTTTTSSSSMIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", 5);
    public static final GeneticCode CILIATE = new GeneticCode("ciliate", "Ciliate", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVVQYQYSSSS*CWCLFLF", 6);
    public static final GeneticCode ECHINODERM_MT = new GeneticCode("echinodermMitochondrial", "Echinoderm Mitochondrial", "NNKNTTTTSSSSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", 9);
    public static final GeneticCode EUPLOTID_NUC = new GeneticCode("euplotidNuclear", "Euplotid Nuclear", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSCCWCLFLF", 10);
    public static final GeneticCode BACTERIAL = new GeneticCode("bacterial", "Bacterial", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSS*CWCLFLF", 11);
    public static final GeneticCode ALT_YEAST = new GeneticCode("alternativeYeast", "Alternative Yeast", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLSLEDEDAAAAGGGGVVVV*Y*YSSSS*CWCLFLF", 12);
    public static final GeneticCode ASCIDIAN_MT = new GeneticCode("ascidianMitochondrial", "Ascidian Mitochondrial", "KNKNTTTTGSGSMIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", 13);
    public static final GeneticCode FLATWORM_MT = new GeneticCode("flatwormMitochondrial", "Flatworm Mitochondrial", "NNKNTTTTSSSSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVVYY*YSSSSWCWCLFLF", 14);
    public static final GeneticCode BLEPHARISMA_NUC = new GeneticCode("blepharismaNuclear", "Blepharisma Nuclear", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*YQYSSSS*CWCLFLF", 15);
    private static final List<GeneticCode> GENETIC_CODES_LIST = Collections.unmodifiableList(Arrays.asList(UNIVERSAL, VERTEBRATE_MT, YEAST, MOLD_PROTOZOAN_MT, MYCOPLASMA, INVERTEBRATE_MT, CILIATE, ECHINODERM_MT, EUPLOTID_NUC, BACTERIAL, ALT_YEAST, ASCIDIAN_MT, FLATWORM_MT, BLEPHARISMA_NUC));
    @Deprecated
    public static final GeneticCode[] GENETIC_CODES = GENETIC_CODES_LIST.toArray(new GeneticCode[GENETIC_CODES_LIST.size()]);
    private int ncbiTranslationTableNumber;
    private final Set<CodonState> startCodons;
    private final String name;
    private final String description;
    private final String codeTable;

    public static Iterable<GeneticCode> getGeneticCodes() {
        return GENETIC_CODES_LIST;
    }

    public static GeneticCode[] getGeneticCodesArray() {
        return GENETIC_CODES_LIST.toArray(new GeneticCode[GENETIC_CODES_LIST.size()]);
    }

    public static GeneticCode valueOf(String name) {
        for (GeneticCode code : GENETIC_CODES_LIST) {
            if (!code.getDescription().equals(name)) continue;
            return code;
        }
        return null;
    }

    public static GeneticCode valueOf(int NCBITranslationTableNumber) {
        for (GeneticCode code : GENETIC_CODES_LIST) {
            if (code.getNcbiTranslationTableNumber() != NCBITranslationTableNumber) continue;
            return code;
        }
        return null;
    }

    private GeneticCode(String name, String description, String codeTable) {
        this(name, description, codeTable, -1, DEFAULT_START_CODONS);
    }

    private GeneticCode(String name, String description, String codeTable, int ncbiTranslationTableNumber) {
        this(name, description, codeTable, ncbiTranslationTableNumber, DEFAULT_START_CODONS);
    }

    private GeneticCode(String name, String description, String codeTable, int ncbiTranslationTableNumber, Set<CodonState> startCodons) {
        this.name = name;
        this.description = description;
        this.codeTable = codeTable;
        this.ncbiTranslationTableNumber = ncbiTranslationTableNumber;
        this.startCodons = startCodons;
        TreeMap<CodonState, AminoAcidState> translationMap = new TreeMap<CodonState, AminoAcidState>();
        if (codeTable.length() != 64) {
            throw new IllegalArgumentException("Code Table length does not match number of codon states");
        }
        int i = 0;
        while (i < codeTable.length()) {
            CodonState codonState = Codons.CANONICAL_STATES[i];
            AminoAcidState aminoAcidState = AminoAcids.getState(codeTable.substring(i, i + 1));
            translationMap.put(codonState, aminoAcidState);
            ++i;
        }
        translationMap.put(Codons.getGapState(), AminoAcids.getGapState());
        translationMap.put(Codons.getUnknownState(), AminoAcids.getUnknownState());
        this.translationMap = Collections.unmodifiableMap(translationMap);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCodeTable() {
        return this.codeTable;
    }

    public AminoAcidState getTranslation(CodonState codonState) {
        return this.translationMap.get(codonState);
    }

    public AminoAcidState getTranslation(NucleotideState nucleotide1, NucleotideState nucleotide2, NucleotideState nucleotide3) {
        CodonState translateState = null;
        if (nucleotide1.isGap() && nucleotide2.isGap() && nucleotide3.isGap()) {
            translateState = Codons.GAP_STATE;
        }
        if (nucleotide1.isAmbiguous() || nucleotide2.isAmbiguous() || nucleotide3.isAmbiguous()) {
            for (State a : nucleotide1.getCanonicalStates()) {
                for (State b : nucleotide2.getCanonicalStates()) {
                    for (State c : nucleotide3.getCanonicalStates()) {
                        CodonState thisDisambiguation = Codons.getState(String.valueOf(a.getCode()) + b.getCode() + c.getCode());
                        if (translateState == null) {
                            translateState = thisDisambiguation;
                        }
                        if (this.translationMap.get(translateState).equals(this.translationMap.get(thisDisambiguation))) continue;
                        return this.translationMap.get(Codons.UNKNOWN_STATE);
                    }
                }
            }
            return this.translationMap.get(translateState);
        }
        String code = String.valueOf(nucleotide1.getCode()) + nucleotide2.getCode() + nucleotide3.getCode();
        translateState = Codons.getState(code);
        return this.translationMap.get(translateState);
    }

    public AminoAcidState getTranslation(String nucleotides) {
        if (nucleotides.length() != 3) {
            throw new IllegalArgumentException("getTranslation requires a nucleotide triplet. (given " + nucleotides.length() + " characters)");
        }
        NucleotideState n1 = Nucleotides.getState(nucleotides.charAt(0));
        NucleotideState n2 = Nucleotides.getState(nucleotides.charAt(1));
        NucleotideState n3 = Nucleotides.getState(nucleotides.charAt(2));
        if (n1 == null) {
            n1 = Nucleotides.UNKNOWN_STATE;
        }
        if (n2 == null) {
            n2 = Nucleotides.UNKNOWN_STATE;
        }
        if (n3 == null) {
            n3 = Nucleotides.UNKNOWN_STATE;
        }
        return this.getTranslation(n1, n2, n3);
    }

    private State[] getTripletStates(String tripletString) throws IllegalArgumentException {
        boolean isValidTriplet = tripletString.length() == 3;
        State[] states = new State[3];
        int i = 0;
        while (i < 3) {
            states[i] = Nucleotides.getState(tripletString.charAt(i));
            isValidTriplet &= states[i] != null;
            ++i;
        }
        if (!isValidTriplet) {
            throw new IllegalArgumentException("Expected valid nucleotide triplet, got '" + tripletString + "'");
        }
        return states;
    }

    public MaybeBoolean isStartCodonString(String tripletString) throws IllegalArgumentException {
        State[] states = this.getTripletStates(tripletString);
        boolean startFound = false;
        boolean nonStartFound = false;
        for (State a : states[0].getCanonicalStates()) {
            for (State b : states[1].getCanonicalStates()) {
                for (State c : states[2].getCanonicalStates()) {
                    CodonState codonState = Codons.getState(String.valueOf(a.getCode()) + b.getCode() + c.getCode());
                    boolean isStart = this.startCodons.contains(codonState);
                    startFound = startFound || isStart;
                    boolean bl = nonStartFound = nonStartFound || !isStart;
                    if (!startFound || !nonStartFound) continue;
                    return MaybeBoolean.Maybe;
                }
            }
        }
        return startFound ? MaybeBoolean.True : MaybeBoolean.False;
    }

    @Deprecated
    public boolean isStartCodon(CodonState codonState) {
        return this.isStartCodonString(codonState.getCode()) == MaybeBoolean.True;
    }

    @Deprecated
    public boolean isStopCodon(CodonState codonState) {
        return this.isStopCodonString(codonState.getCode()) == MaybeBoolean.True;
    }

    public MaybeBoolean isStopCodonString(String tripletString) throws IllegalArgumentException {
        State[] states = this.getTripletStates(tripletString);
        boolean stopFound = false;
        boolean nonStopFound = false;
        for (State a : states[0].getCanonicalStates()) {
            for (State b : states[1].getCanonicalStates()) {
                for (State c : states[2].getCanonicalStates()) {
                    CodonState codonState = Codons.getState(String.valueOf(a.getCode()) + b.getCode() + c.getCode());
                    boolean isStop = this.translationMap.get(codonState).equals(AminoAcids.STOP_STATE);
                    stopFound = stopFound || isStop;
                    boolean bl = nonStopFound = nonStopFound || !isStop;
                    if (!stopFound || !nonStopFound) continue;
                    return MaybeBoolean.Maybe;
                }
            }
        }
        return stopFound ? MaybeBoolean.True : MaybeBoolean.False;
    }

    public Set<CodonState> getCodonsForAminoAcid(AminoAcidState aminoAcidState) {
        HashSet<CodonState> aaSet = new HashSet<CodonState>();
        for (CodonState state : this.translationMap.keySet()) {
            if (this.translationMap.get(state) != aminoAcidState) continue;
            aaSet.add(state);
        }
        return aaSet;
    }

    public Set<CodonState> getStartCodons() {
        return Collections.unmodifiableSet(this.startCodons);
    }

    public Set<CodonState> getStopCodons() {
        HashSet<CodonState> stopSet = new HashSet<CodonState>();
        for (CodonState state : this.translationMap.keySet()) {
            if (this.isStopCodonString(state.getCode()) != MaybeBoolean.True) continue;
            stopSet.add(state);
        }
        return stopSet;
    }

    public int getStopCodonCount() {
        int count = 0;
        for (AminoAcidState state : this.translationMap.values()) {
            if (state != AminoAcids.STOP_STATE) continue;
            ++count;
        }
        return count;
    }

    public int getNcbiTranslationTableNumber() {
        return this.ncbiTranslationTableNumber;
    }

    public String toString() {
        return this.getDescription();
    }
}

