/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jebl.evolution.sequences.NucleotideState;
import jebl.evolution.sequences.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Nucleotides {
    public static final String NAME = "nucleotide";
    public static final int CANONICAL_STATE_COUNT = 4;
    public static final int STATE_COUNT = 17;
    public static final NucleotideState A_STATE = new NucleotideState("Adenine", "A", 0);
    public static final NucleotideState C_STATE = new NucleotideState("Cytosine", "C", 1);
    public static final NucleotideState G_STATE = new NucleotideState("Guanine", "G", 2);
    public static final NucleotideState T_STATE = new NucleotideState("Thymine", "T", 3);
    public static final NucleotideState R_STATE = new NucleotideState("A/G", "R", 4, new NucleotideState[]{A_STATE, G_STATE});
    public static final NucleotideState Y_STATE = new NucleotideState("C/T", "Y", 5, new NucleotideState[]{C_STATE, T_STATE});
    public static final NucleotideState M_STATE = new NucleotideState("A/C", "M", 6, new NucleotideState[]{A_STATE, C_STATE});
    public static final NucleotideState W_STATE = new NucleotideState("A/T", "W", 7, new NucleotideState[]{A_STATE, T_STATE});
    public static final NucleotideState S_STATE = new NucleotideState("C/G", "S", 8, new NucleotideState[]{C_STATE, G_STATE});
    public static final NucleotideState K_STATE = new NucleotideState("G/T", "K", 9, new NucleotideState[]{G_STATE, T_STATE});
    public static final NucleotideState B_STATE = new NucleotideState("C/G/T", "B", 10, new NucleotideState[]{C_STATE, G_STATE, T_STATE});
    public static final NucleotideState D_STATE = new NucleotideState("A/G/T", "D", 11, new NucleotideState[]{A_STATE, G_STATE, T_STATE});
    public static final NucleotideState H_STATE = new NucleotideState("A/C/T", "H", 12, new NucleotideState[]{A_STATE, C_STATE, T_STATE});
    public static final NucleotideState V_STATE = new NucleotideState("A/C/G", "V", 13, new NucleotideState[]{A_STATE, C_STATE, G_STATE});
    public static final NucleotideState N_STATE = new NucleotideState("Unknown base", "N", 14, new NucleotideState[]{A_STATE, C_STATE, G_STATE, T_STATE});
    public static final NucleotideState UNKNOWN_STATE = new NucleotideState("Unknown base", "?", 15, new NucleotideState[]{A_STATE, C_STATE, G_STATE, T_STATE});
    public static final NucleotideState GAP_STATE = new NucleotideState("Gap", "-", 16, new NucleotideState[]{A_STATE, C_STATE, G_STATE, T_STATE});
    @Deprecated
    public static final NucleotideState[] CANONICAL_STATES = new NucleotideState[]{A_STATE, C_STATE, G_STATE, T_STATE};
    @Deprecated
    public static final NucleotideState[] STATES = new NucleotideState[]{A_STATE, C_STATE, G_STATE, T_STATE, R_STATE, Y_STATE, M_STATE, W_STATE, S_STATE, K_STATE, B_STATE, D_STATE, H_STATE, V_STATE, N_STATE, UNKNOWN_STATE, GAP_STATE};
    @Deprecated
    public static final NucleotideState[] COMPLEMENTARY_STATES = new NucleotideState[]{T_STATE, G_STATE, C_STATE, A_STATE, Y_STATE, R_STATE, K_STATE, W_STATE, S_STATE, M_STATE, V_STATE, H_STATE, D_STATE, B_STATE, N_STATE, UNKNOWN_STATE, GAP_STATE};
    private static final int STATES_BY_CODE_SIZE = 128;
    private static final NucleotideState[] statesByCode = new NucleotideState[128];
    private static boolean[][] isPossibleTransition;
    private static boolean[][] isPossibleTransversion;

    static {
        int i = 0;
        while (i < statesByCode.length) {
            Nucleotides.statesByCode[i] = null;
            ++i;
        }
        NucleotideState[] nucleotideStateArray = STATES;
        int n = STATES.length;
        int n2 = 0;
        while (n2 < n) {
            NucleotideState state;
            Nucleotides.statesByCode[state.getCode().charAt((int)0)] = state = nucleotideStateArray[n2];
            Nucleotides.statesByCode[Character.toLowerCase((char)state.getCode().charAt((int)0))] = state;
            ++n2;
        }
        Nucleotides.statesByCode[117] = T_STATE;
        Nucleotides.statesByCode[85] = T_STATE;
        isPossibleTransition = new boolean[128][128];
        isPossibleTransversion = new boolean[128][128];
        i = 0;
        while (i < 128) {
            int j = 0;
            while (j < 128) {
                char c1 = (char)i;
                char c2 = (char)j;
                NucleotideState s1 = Nucleotides.getState(c1);
                NucleotideState s2 = Nucleotides.getState(c2);
                Nucleotides.isPossibleTransition[i][j] = s1 != null && s2 != null && Nucleotides.calculateIsPossibleTransition(s1, s2);
                Nucleotides.isPossibleTransversion[i][j] = s1 != null && s2 != null && Nucleotides.calculateIsPossibleTransversion(s1, s2);
                ++j;
            }
            ++i;
        }
    }

    private Nucleotides() {
    }

    public static NucleotideState getComplementaryState(NucleotideState state) {
        return COMPLEMENTARY_STATES[state.getIndex()];
    }

    public static int getStateCount() {
        return 17;
    }

    public static List<State> getStates() {
        return Collections.unmodifiableList(Arrays.asList(STATES));
    }

    public static int getCanonicalStateCount() {
        return 4;
    }

    public static List<NucleotideState> getCanonicalStates() {
        return Collections.unmodifiableList(Arrays.asList(CANONICAL_STATES));
    }

    public static NucleotideState getState(char code) {
        if (code < '\u0000' || code >= '\u0080') {
            return null;
        }
        return statesByCode[code];
    }

    public static NucleotideState getState(String code) {
        return Nucleotides.getState(code.charAt(0));
    }

    public static NucleotideState getState(int index) {
        return STATES[index];
    }

    public static NucleotideState getUnknownState() {
        return UNKNOWN_STATE;
    }

    public static NucleotideState getGapState() {
        return GAP_STATE;
    }

    public static boolean isUnknown(NucleotideState state) {
        return state == UNKNOWN_STATE;
    }

    public static boolean isGap(NucleotideState state) {
        return state == GAP_STATE;
    }

    public static boolean isTransition(State state1, State state2) {
        if (state1.isGap() || state1.isAmbiguous() || state2.isGap() || state2.isAmbiguous() || state1 == state2) {
            return false;
        }
        return (state1.getIndex() + state2.getIndex() & 1) == 0;
    }

    public static boolean isTransversion(State state1, State state2) {
        if (state1.isGap() || state1.isAmbiguous() || state2.isGap() || state2.isAmbiguous() || state1 == state2) {
            return false;
        }
        return !Nucleotides.isTransition(state1, state2);
    }

    public static boolean isPossibleTransition(char c1, char c2) {
        if (c1 > '\u007f' || c2 > '\u007f') {
            return false;
        }
        return isPossibleTransition[c1][c2];
    }

    public static boolean isPossibleTransversion(char c1, char c2) {
        if (c1 > '\u007f' || c2 > '\u007f') {
            return false;
        }
        return isPossibleTransversion[c1][c2];
    }

    public static boolean isPossibleTransition(State s1, State s2) {
        return isPossibleTransition[s1.getCode().charAt(0)][s2.getCode().charAt(0)];
    }

    public static boolean isPossibleTransversion(State s1, State s2) {
        return isPossibleTransversion[s1.getCode().charAt(0)][s2.getCode().charAt(0)];
    }

    private static boolean calculateIsPossibleTransition(State s1, State s2) {
        if (s1.isGap() || s2.isGap()) {
            return false;
        }
        for (State state1 : s1.getCanonicalStates()) {
            for (State state2 : s2.getCanonicalStates()) {
                if (!Nucleotides.isTransition(state1, state2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean calculateIsPossibleTransversion(State s1, State s2) {
        if (s1.isGap() || s2.isGap()) {
            return false;
        }
        for (State state1 : s1.getCanonicalStates()) {
            for (State state2 : s2.getCanonicalStates()) {
                if (!Nucleotides.isTransversion(state1, state2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPurine(State state) {
        if (state.isAmbiguous()) {
            for (State state1 : state.getCanonicalStates()) {
                if (Nucleotides.isPurine(state1)) continue;
                return false;
            }
            return true;
        }
        return state == A_STATE || state == G_STATE;
    }

    public static boolean isPyrimidine(State state) {
        if (state.isAmbiguous()) {
            for (State state1 : state.getCanonicalStates()) {
                if (Nucleotides.isPyrimidine(state1)) continue;
                return false;
            }
            return true;
        }
        return state == C_STATE || state == T_STATE;
    }

    public static boolean isGCstate(State state) {
        return state == G_STATE || state == C_STATE || state == S_STATE;
    }

    public static boolean isATstate(State state) {
        return state == A_STATE || state == T_STATE || state == W_STATE;
    }

    public String getName() {
        return "Nucleotides";
    }

    public static NucleotideState[] toStateArray(String sequenceString) {
        NucleotideState[] seq = new NucleotideState[sequenceString.length()];
        int i = 0;
        while (i < seq.length) {
            seq[i] = Nucleotides.getState(sequenceString.charAt(i));
            ++i;
        }
        return seq;
    }

    public static NucleotideState[] toStateArray(byte[] indexArray) {
        NucleotideState[] seq = new NucleotideState[indexArray.length];
        int i = 0;
        while (i < seq.length) {
            seq[i] = Nucleotides.getState(indexArray[i]);
            ++i;
        }
        return seq;
    }
}

