/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.ConsensusTreeBuilder;
import jebl.evolution.trees.MutableRootedTree;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Utils;
import jebl.util.FixedBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GreedyRootedConsensusTreeBuilder
extends ConsensusTreeBuilder<RootedTree> {
    private final RootedTree[] rtrees;
    private final double supportThreshold;
    private final boolean debug = false;

    public GreedyRootedConsensusTreeBuilder(RootedTree[] trees, double supportThreshold) {
        super(trees);
        this.rtrees = trees;
        this.supportThreshold = supportThreshold;
    }

    public GreedyRootedConsensusTreeBuilder(RootedTree[] trees, double supportThreshold, String supportAttributeName, boolean asPercent) {
        super(trees, supportAttributeName, asPercent);
        this.rtrees = trees;
        this.supportThreshold = supportThreshold;
    }

    @Override
    public String getMethodDescription() {
        String supporDescription = this.getSupportDescription(this.supportThreshold);
        return String.valueOf(supporDescription) + " greedy clustering";
    }

    private String tipsAsText(FixedBitSet b) {
        String names = "(";
        int i = b.nextOnBit(0);
        while (i >= 0) {
            names = String.valueOf(names) + ((Taxon)this.taxons.get(i)).getName() + ",";
            i = b.nextOnBit(i + 1);
        }
        return String.valueOf(names) + ")";
    }

    private FixedBitSet rootedSupport(RootedTree tree, Node node, Map<FixedBitSet, Support> support) {
        FixedBitSet clade = new FixedBitSet(this.nExternalNodes);
        if (tree.isExternal(node)) {
            clade.set(this.taxons.indexOf(tree.getTaxon(node)));
        } else {
            for (Node n : tree.getChildren(node)) {
                FixedBitSet childClade = this.rootedSupport(tree, n, support);
                clade.union(childClade);
            }
        }
        Support s = support.get(clade);
        if (s == null) {
            s = new Support();
            support.put(clade, s);
        }
        s.add(Utils.safeNodeHeight(tree, node));
        return clade;
    }

    private double insureConsistency(MutableRootedTree tree, Node node) {
        double height = Utils.safeNodeHeight(tree, node);
        if (tree.isExternal(node)) {
            return height;
        }
        for (Node n : tree.getChildren(node)) {
            double childHeight = this.insureConsistency(tree, n);
            height = Math.max(height, childHeight);
        }
        tree.setHeight(node, height);
        return height;
    }

    @Override
    public final RootedTree build() {
        LinkedHashMap<FixedBitSet, Support> support = new LinkedHashMap<FixedBitSet, Support>();
        int k = 0;
        RootedTree[] rootedTreeArray = this.rtrees;
        int n = this.rtrees.length;
        int n2 = 0;
        while (n2 < n) {
            RootedTree tree = rootedTreeArray[n2];
            this.rootedSupport(tree, tree.getRootNode(), support);
            if (this.fireSetProgress(0.9 * (double)(++k) / (double)this.rtrees.length)) {
                return null;
            }
            ++n2;
        }
        int nTrees = this.rtrees.length;
        MutableRootedTree consTree = new MutableRootedTree();
        ArrayList<Node> internalNodes = new ArrayList<Node>(this.nExternalNodes);
        ArrayList<FixedBitSet> internalNodesTips = new ArrayList<FixedBitSet>(this.nExternalNodes);
        assert (this.taxons.size() == this.nExternalNodes);
        internalNodesTips.add(new FixedBitSet(this.nExternalNodes));
        FixedBitSet rooNode = (FixedBitSet)internalNodesTips.get(0);
        Node[] nodes = new Node[this.nExternalNodes];
        int nt = 0;
        while (nt < this.taxons.size()) {
            nodes[nt] = consTree.createExternalNode((Taxon)this.taxons.get(nt));
            rooNode.set(nt);
            ++nt;
        }
        internalNodes.add(consTree.createInternalNode(Arrays.asList(nodes)));
        Comparator<Map.Entry<FixedBitSet, Support>> comparator = new Comparator<Map.Entry<FixedBitSet, Support>>(){

            @Override
            public int compare(Map.Entry<FixedBitSet, Support> o1, Map.Entry<FixedBitSet, Support> o2) {
                return o2.getValue().nTreesWithClade - o1.getValue().nTreesWithClade;
            }
        };
        PriorityQueue<Map.Entry<FixedBitSet, Support>> queue = new PriorityQueue<Map.Entry<FixedBitSet, Support>>(support.size(), comparator);
        for (Map.Entry se : support.entrySet()) {
            Support s = (Support)se.getValue();
            FixedBitSet clade = (FixedBitSet)se.getKey();
            int cladeSize = clade.cardinality();
            if (cladeSize == this.nExternalNodes) {
                consTree.setHeight(consTree.getRootNode(), s.sumBranches / (double)nTrees);
                continue;
            }
            if (s.nTreesWithClade == nTrees && cladeSize == 1) {
                int nt2 = clade.nextOnBit(0);
                Node leaf = consTree.getNode((Taxon)this.taxons.get(nt2));
                consTree.setHeight(leaf, s.sumBranches / (double)nTrees);
            } else {
                queue.add(se);
            }
            if (!this.fireSetProgress(0.95)) continue;
            return null;
        }
        while (queue.peek() != null) {
            Map.Entry<FixedBitSet, Support> e = queue.poll();
            Support s = e.getValue();
            double psupport = 1.0 * (double)s.nTreesWithClade / (double)nTrees;
            if (psupport < this.supportThreshold) break;
            FixedBitSet cladeTips = e.getKey();
            boolean found = false;
            int nsub = internalNodesTips.size() - 1;
            while (nsub >= 0) {
                FixedBitSet allNodeTips = (FixedBitSet)internalNodesTips.get(nsub);
                int nSplit = allNodeTips.intersectCardinality(cladeTips);
                if (nSplit == cladeTips.cardinality()) {
                    found = true;
                    ArrayList<Integer> split = new ArrayList<Integer>();
                    Node n3 = (Node)internalNodes.get(nsub);
                    int l = 0;
                    List<Node> children = consTree.getChildren(n3);
                    for (Node ch : children) {
                        if (consTree.isExternal(ch)) {
                            if (cladeTips.contains(this.taxons.indexOf(consTree.getTaxon(ch)))) {
                                split.add(l);
                            }
                        } else {
                            int o = internalNodes.indexOf(ch);
                            int i = ((FixedBitSet)internalNodesTips.get(o)).intersectCardinality(cladeTips);
                            if (i == ((FixedBitSet)internalNodesTips.get(o)).cardinality()) {
                                split.add(l);
                            } else if (i > 0) {
                                found = false;
                                break;
                            }
                        }
                        ++l;
                    }
                    if (!found || split.size() >= children.size()) {
                        found = false;
                        break;
                    }
                    if (split.size() == 0) {
                        System.out.println("Bug??");
                        assert (false);
                    }
                    Node detached = consTree.detachChildren(n3, split);
                    double height = s.sumBranches / (double)s.nTreesWithClade;
                    consTree.setHeight(detached, height);
                    detached.setAttribute(this.getSupportAttributeName(), this.isSupportAsPercent() ? 100.0 * psupport : psupport);
                    internalNodes.add(nsub + 1, detached);
                    internalNodesTips.add(nsub + 1, new FixedBitSet(cladeTips));
                    break;
                }
                --nsub;
            }
            if (psupport >= 0.5 && !found) {
                System.out.println("Bug??");
                assert (false);
            }
            if (!this.fireSetProgress(0.99)) continue;
            return null;
        }
        this.insureConsistency(consTree, consTree.getRootNode());
        this.fireSetProgress(1.0);
        return consTree;
    }

    static final class Support {
        private int nTreesWithClade = 0;
        private double sumBranches = 0.0;

        Support() {
        }

        public final void add(double height) {
            this.sumBranches += height;
            ++this.nTreesWithClade;
        }
    }
}

