/*
 * Decompiled with CFR 0.152.
 */
package jebl.math;

import jebl.math.MinimiserMonitor;
import jebl.math.MultivariateFunction;

public abstract class MultivariateMinimum {
    public int numFun;
    public int maxFun = 0;
    public int numFuncStops = 4;
    private int countFuncStops;
    private double fxold;
    private double[] xold;

    public double findMinimum(MultivariateFunction f, double[] xvec) {
        this.optimize(f, xvec, 2.220446049250313E-16, 2.220446049250313E-16);
        return f.evaluate(xvec);
    }

    public double findMinimum(MultivariateFunction f, double[] xvec, int fxFracDigits, int xFracDigits) {
        return this.findMinimum(f, xvec, fxFracDigits, xFracDigits, null);
    }

    public double findMinimum(MultivariateFunction f, double[] xvec, int fxFracDigits, int xFracDigits, MinimiserMonitor monitor) {
        double tolfx = Math.pow(10.0, -1 - fxFracDigits);
        double tolx = Math.pow(10.0, -1 - xFracDigits);
        this.optimize(f, xvec, tolfx, tolx, monitor);
        double m = Math.pow(10.0, xFracDigits);
        int i = 0;
        while (i < xvec.length) {
            xvec[i] = (double)Math.round(xvec[i] * m) / m;
            ++i;
        }
        return (double)Math.round(f.evaluate(xvec) * m) / m;
    }

    public abstract void optimize(MultivariateFunction var1, double[] var2, double var3, double var5);

    public void optimize(MultivariateFunction f, double[] xvec, double tolfx, double tolx, MinimiserMonitor monitor) {
        this.optimize(f, xvec, tolfx, tolx);
    }

    public boolean stopCondition(double fx, double[] x, double tolfx, double tolx, boolean firstCall) {
        boolean stop = false;
        if (firstCall) {
            this.countFuncStops = 0;
            this.fxold = fx;
            this.xold = new double[x.length];
            MultivariateMinimum.copy(this.xold, x);
        } else if (this.xStop(x, this.xold, tolx)) {
            stop = true;
        } else {
            this.countFuncStops = this.fxStop(fx, this.fxold, tolfx) ? ++this.countFuncStops : 0;
            if (this.countFuncStops >= this.numFuncStops) {
                stop = true;
            }
        }
        if (!stop) {
            this.fxold = fx;
            MultivariateMinimum.copy(this.xold, x);
        }
        return stop;
    }

    public static final void copy(double[] target, double[] source) {
        System.arraycopy(source, 0, target, 0, source.length);
    }

    private boolean xStop(double[] x, double[] xold, double tolx) {
        boolean stop = true;
        int i = 0;
        while (i < x.length && stop) {
            if (Math.abs(x[i] - xold[i]) > tolx) {
                stop = false;
            }
            ++i;
        }
        return stop;
    }

    private boolean fxStop(double fx, double fxold, double tolfx) {
        return !(Math.abs(fx - fxold) > tolfx);
    }

    public static interface Factory {
        public MultivariateMinimum generateNewMinimiser();
    }
}

