/*
 * Decompiled with CFR 0.152.
 */
package jebl.util;

import java.awt.Image;
import java.io.File;
import java.util.List;
import jebl.math.MachineAccuracy;
import jebl.util.ProgressListener;
import jebl.util.SimpleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeProgressListener
extends ProgressListener {
    private int numOperations;
    private ProgressListener listener;
    private int currentOperationNum = 0;
    private double[] taskFractions;
    private double taskFractionIfTasksAreEvenlyWeighted;
    private double baseTime = 0.0;
    private double currentOperationProgress = 0.0;
    private boolean beganFirstSubTask = false;
    private String currentSubTaskMessage = "";

    public CompositeProgressListener(ProgressListener listener, double ... operationDuration) {
        this.numOperations = operationDuration.length;
        if (this.numOperations == 0) {
            throw new IllegalArgumentException("Composite operation must have > 0 subtasks");
        }
        this.listener = listener == null ? ProgressListener.EMPTY : listener;
        this.taskFractions = (double[])operationDuration.clone();
        double totalTime = 0.0;
        double[] dArray = operationDuration;
        int n = operationDuration.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d < 0.0) {
                throw new IllegalArgumentException("Operation cannot take negative time: " + d);
            }
            totalTime += d;
            ++n2;
        }
        if (MachineAccuracy.same(totalTime, 0.0)) {
            throw new IllegalArgumentException("There must be at least one subtask that takes > 0 time");
        }
        int i = 0;
        while (i < this.numOperations) {
            this.taskFractions[i] = operationDuration[i] / totalTime;
            ++i;
        }
    }

    public CompositeProgressListener(ProgressListener listener, int numberOfEvenlyWeightedSubTasks) {
        if (numberOfEvenlyWeightedSubTasks < 0) {
            throw new IllegalArgumentException("numberOfEvenlyWeightedSubTasks=" + numberOfEvenlyWeightedSubTasks + " but it must be >=0");
        }
        this.numOperations = numberOfEvenlyWeightedSubTasks;
        this.taskFractionIfTasksAreEvenlyWeighted = numberOfEvenlyWeightedSubTasks > 0 ? 1.0 / (double)numberOfEvenlyWeightedSubTasks : 1.0;
        this.listener = listener == null ? ProgressListener.EMPTY : listener;
    }

    public static CompositeProgressListener forFiles(ProgressListener listener, List<File> files) {
        int n = files.size();
        double[] lengths = new double[n];
        int i = 0;
        for (File file : files) {
            lengths[i++] = file.length();
        }
        return new CompositeProgressListener(listener, lengths);
    }

    public void beginSubtask() {
        if (this.numOperations == 0) {
            throw new IllegalStateException("This operation has no subtasks");
        }
        this.currentSubTaskMessage = "";
        if (!this.beganFirstSubTask) {
            this.beganFirstSubTask = true;
        } else {
            this.beginNextSubtask();
        }
    }

    public void beginSubtask(String message) {
        this.currentSubTaskMessage = message;
        this.setMessage("");
        this.beginSubtask();
        this.currentSubTaskMessage = message;
    }

    @Override
    protected void _setProgress(double fractionCompleted) {
        if (fractionCompleted > 1.0000001) assert (false) : "Progress should be <= 1.  Passed in " + fractionCompleted;
        if (fractionCompleted > 1.0) {
            fractionCompleted = 1.0;
        }
        if (fractionCompleted < this.currentOperationProgress) assert (false) : "Progress shouldn't go backwards. Went from " + this.currentOperationProgress + " to " + fractionCompleted;
        if (fractionCompleted < 0.0) assert (false) : "Progress must be >=0 but got " + fractionCompleted;
        this.currentOperationProgress = fractionCompleted;
        this.listener._setProgress(this.baseTime + fractionCompleted * this.getTaskFraction(this.currentOperationNum));
    }

    private double getTaskFraction(int operationNum) {
        if (this.taskFractions == null) {
            return this.taskFractionIfTasksAreEvenlyWeighted;
        }
        return this.taskFractions[operationNum];
    }

    @Override
    protected void _setIndeterminateProgress() {
        this.listener._setIndeterminateProgress();
    }

    @Override
    protected void _setMessage(String message) {
        if (this.currentSubTaskMessage.length() > 0) {
            message = String.valueOf(this.currentSubTaskMessage) + (message.length() > 0 ? ": " + message : "");
        }
        this.listener._setMessage(message);
    }

    @Override
    public boolean isCanceled() {
        return this.listener.isCanceled();
    }

    public boolean addProgress(double fractionCompletedDiff) {
        return this.setProgress(this.currentOperationProgress + fractionCompletedDiff);
    }

    public boolean hasNextSubtask() {
        return this.currentOperationNum < this.numOperations - 1;
    }

    public void clearAllProgress() {
        this.currentOperationNum = 0;
        this.baseTime = 0.0;
        this.setProgress(0.0);
    }

    public void beginNextSubtask(String message) {
        this.beginNextSubtask();
        this.currentSubTaskMessage = message;
        this.setMessage("");
    }

    public void beginNextSubtask() {
        this.currentSubTaskMessage = "";
        this.setComplete();
        if (!this.hasNextSubtask()) {
            throw new IllegalStateException(String.valueOf(this.currentOperationNum) + " " + this.numOperations);
        }
        this.baseTime += this.getTaskFraction(this.currentOperationNum);
        ++this.currentOperationNum;
        this.currentOperationProgress = 0.0;
    }

    public final boolean setComplete() {
        return this.setProgress(1.0);
    }

    public ProgressListener getRootProgressListener() {
        if (this.listener instanceof CompositeProgressListener) {
            return ((CompositeProgressListener)this.listener).getRootProgressListener();
        }
        return this.listener;
    }

    @Override
    public void addFeedbackAction(String label, SimpleListener listener) {
        this.listener.addFeedbackAction(label, listener);
    }

    @Override
    public void addFeedbackAction(String label, String description, SimpleListener listener) {
        this.listener.addFeedbackAction(label, description, listener);
    }

    @Override
    public void removeFeedbackAction(String label) {
        this.listener.removeFeedbackAction(label);
    }

    @Override
    public void setTitle(String title) {
        this.listener.setTitle(title);
    }

    @Override
    protected void _setImage(Image image) {
        this.listener._setImage(image);
    }
}

