/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.kienerj.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class OptimizedRandomAccessFile {
    private static final int BUFFER_SIZE = 8192;
    private static int defaultExpectedLineLength = 80;
    private RandomAccessFile raf;
    private Long actualFilePointer;
    private char[] charBuffer;
    private int nChars;
    private int nextChar;
    private int bufferSize;
    private long lastOffset;
    private boolean skipLF;

    public OptimizedRandomAccessFile(String name, String mode) throws FileNotFoundException {
        this(name != null ? new File(name) : null, mode);
    }

    public OptimizedRandomAccessFile(File file, String mode) throws FileNotFoundException {
        this.raf = new RandomAccessFile(file, mode);
        this.actualFilePointer = null;
        this.bufferSize = 8192;
        this.charBuffer = new char[this.bufferSize];
    }

    public final FileDescriptor getFD() throws IOException {
        return this.raf.getFD();
    }

    public synchronized int read() throws IOException {
        while (true) {
            if (this.nextChar >= this.nChars) {
                this.fill();
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
            if (!this.skipLF) break;
            this.skipLF = false;
            if (this.charBuffer[this.nextChar] != '\n') break;
            ++this.nextChar;
        }
        char result = this.charBuffer[this.nextChar++];
        Long l = this.actualFilePointer;
        this.actualFilePointer = this.actualFilePointer + 1L;
        return result;
    }

    private int read1(byte[] cbuf, int off, int len) throws IOException {
        if (this.nextChar >= this.nChars) {
            if (len >= this.charBuffer.length && !this.skipLF) {
                this.actualFilePointer = null;
                return this.raf.read(cbuf, off, len);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (this.charBuffer[this.nextChar] == '\n') {
                ++this.nextChar;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n = Math.min(len, this.nChars - this.nextChar);
        for (int i = 0; i < n; ++i) {
            cbuf[off + i] = (byte)this.charBuffer[this.nextChar + i];
        }
        this.nextChar += n;
        this.actualFilePointer = this.actualFilePointer + (long)n;
        return n;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int n1;
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = this.read1(b, off, len);
        if (n <= 0) {
            return n;
        }
        while (n < len && (n1 = this.read1(b, off + n, len - n)) > 0) {
            n += n1;
        }
        return n;
    }

    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public final synchronized void readFully(byte[] b) throws IOException {
        this.resetPosition();
        this.raf.readFully(b);
    }

    public final synchronized void readFully(byte[] b, int off, int len) throws IOException {
        this.resetPosition();
        this.raf.readFully(b, off, len);
    }

    public synchronized int skipBytes(int n) throws IOException {
        if ((long)n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        int r = n;
        while (r > 0) {
            long d;
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) break;
            if (this.skipLF) {
                this.skipLF = false;
                if (this.charBuffer[this.nextChar] == '\n') {
                    ++this.nextChar;
                }
            }
            if ((long)r <= (d = (long)(this.nChars - this.nextChar))) {
                this.nextChar += r;
                r = 0;
                break;
            }
            r = (int)((long)r - d);
            this.nextChar = this.nChars;
        }
        int skipped = n - r;
        this.actualFilePointer = this.actualFilePointer + (long)skipped;
        return skipped;
    }

    public synchronized void write(int b) throws IOException {
        this.resetPosition();
        this.raf.write(b);
    }

    public synchronized void write(byte[] b) throws IOException {
        this.resetPosition();
        this.raf.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.resetPosition();
        this.raf.write(b, off, len);
    }

    public synchronized long getFilePointer() throws IOException {
        if (this.actualFilePointer == null) {
            return this.raf.getFilePointer();
        }
        return this.actualFilePointer;
    }

    public synchronized void seek(long pos) throws IOException {
        this.actualFilePointer = null;
        this.resetPosition();
        this.raf.seek(pos);
    }

    public synchronized long length() throws IOException {
        return this.raf.length();
    }

    public synchronized void setLength(long newLength) throws IOException {
        if (newLength < this.raf.length()) {
            this.resetPosition();
        }
        this.raf.setLength(newLength);
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public final synchronized boolean readBoolean() throws IOException {
        this.resetPosition();
        return this.raf.readBoolean();
    }

    public final synchronized byte readByte() throws IOException {
        this.resetPosition();
        return this.raf.readByte();
    }

    public final synchronized int readUnsignedByte() throws IOException {
        this.resetPosition();
        return this.raf.readUnsignedByte();
    }

    public final synchronized short readShort() throws IOException {
        this.resetPosition();
        return this.raf.readShort();
    }

    public final synchronized int readUnsignedShort() throws IOException {
        this.resetPosition();
        return this.raf.readUnsignedShort();
    }

    public final synchronized char readChar() throws IOException {
        this.resetPosition();
        return this.raf.readChar();
    }

    public final synchronized int readInt() throws IOException {
        this.resetPosition();
        return this.raf.readInt();
    }

    public final synchronized long readLong() throws IOException {
        this.resetPosition();
        return this.raf.readLong();
    }

    public final synchronized float readFloat() throws IOException {
        this.resetPosition();
        return this.raf.readFloat();
    }

    public final synchronized double readDouble() throws IOException {
        this.resetPosition();
        return this.raf.readDouble();
    }

    public final synchronized String readLine(boolean ignoreLF) throws IOException {
        boolean omitLF;
        StringBuilder s = null;
        int separatorIndex = 0;
        boolean bl = omitLF = ignoreLF || this.skipLF;
        while (true) {
            int i;
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                if (s != null && s.length() > 0) {
                    return s.toString();
                }
                return null;
            }
            boolean eol = false;
            char c = '\u0000';
            if (!omitLF || this.charBuffer[this.nextChar] == '\n') {
                // empty if block
            }
            this.skipLF = false;
            omitLF = false;
            for (i = ++this.nextChar; i < this.nChars; ++i) {
                c = this.charBuffer[i];
                if (c != '\n' && c != '\r') continue;
                eol = true;
                break;
            }
            int startChar = this.nextChar;
            this.nextChar = i;
            if (eol) {
                String str;
                if (s == null) {
                    str = new String(this.charBuffer, startChar, i - startChar);
                } else {
                    s.append(this.charBuffer, startChar, i - startChar);
                    str = s.toString();
                }
                ++this.nextChar;
                if (c == '\r') {
                    this.skipLF = true;
                    if (this.nextChar >= this.nChars) {
                        this.fill();
                    }
                    if (this.charBuffer[this.nextChar] == '\n') {
                        separatorIndex = 1;
                    }
                }
                this.actualFilePointer = this.lastOffset + (long)this.nextChar + (long)separatorIndex;
                return str;
            }
            if (s == null) {
                s = new StringBuilder(defaultExpectedLineLength);
            }
            s.append(this.charBuffer, startChar, i - startChar);
        }
    }

    public synchronized String readLine() throws IOException {
        return this.readLine(false);
    }

    private void fill() throws IOException {
        this.lastOffset = this.raf.getFilePointer();
        this.actualFilePointer = this.lastOffset;
        byte[] buffer = new byte[this.bufferSize];
        int n = this.raf.read(buffer);
        if (n > 0) {
            this.nChars = n;
            this.nextChar = 0;
        }
        for (int i = 0; i < buffer.length; ++i) {
            this.charBuffer[i] = (char)buffer[i];
        }
    }

    public final synchronized String readUTF() throws IOException {
        this.resetPosition();
        return this.raf.readUTF();
    }

    public final synchronized void writeBoolean(boolean v) throws IOException {
        this.resetPosition();
        this.raf.writeBoolean(v);
    }

    public final synchronized void writeByte(int v) throws IOException {
        this.resetPosition();
        this.raf.writeByte(v);
    }

    public final synchronized void writeShort(int v) throws IOException {
        this.resetPosition();
        this.raf.writeShort(v);
    }

    public final synchronized void writeChar(int v) throws IOException {
        this.resetPosition();
        this.raf.writeChar(v);
    }

    public final synchronized void writeInt(int v) throws IOException {
        this.resetPosition();
        this.raf.writeInt(v);
    }

    public final synchronized void writeLong(long v) throws IOException {
        this.resetPosition();
        this.raf.writeLong(v);
    }

    public final synchronized void writeFloat(float v) throws IOException {
        this.resetPosition();
        this.raf.writeFloat(v);
    }

    public final synchronized void writeDouble(double v) throws IOException {
        this.resetPosition();
        this.raf.writeDouble(v);
    }

    public final synchronized void writeBytes(String s) throws IOException {
        this.resetPosition();
        this.raf.writeBytes(s);
    }

    public final synchronized void writeChars(String s) throws IOException {
        this.resetPosition();
        this.raf.writeChars(s);
    }

    public final synchronized void writeUTF(String str) throws IOException {
        this.resetPosition();
        this.raf.writeUTF(str);
    }

    private void resetPosition() throws IOException {
        if (this.actualFilePointer != null) {
            this.raf.seek(this.actualFilePointer);
            this.actualFilePointer = null;
        }
        this.nChars = 0;
        this.nextChar = 0;
    }
}

