/*
 * Decompiled with CFR 0.152.
 */
package utils;

import aliview.AliView;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.simplericity.macify.eawt.DefaultApplication;
import utils.OSXHandlerJava9;

public class OSNativeUtils {
    private static final Logger logger = Logger.getLogger(OSNativeUtils.class);

    public static void main(String[] args) {
        double version = OSNativeUtils.getJavaVersionAsDouble();
        logger.info("version=" + version);
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static double getHighDPIScaleFactor(Component component) {
        double scaleFactor = -1.0;
        if (OSNativeUtils.isJavaVersion8orLower()) {
            double scaleFactorJ6 = OSNativeUtils.getHighDPIScaleFactor_OSX_Java6();
            logger.info("scaleFactorJ6" + scaleFactorJ6);
            double scaleFactorJ8 = OSNativeUtils.getHighDPIScaleFactor_OSX_Java_Pre_9(component);
            logger.info("scaleFactorJ8" + scaleFactorJ8);
            scaleFactor = Math.max(scaleFactorJ6, scaleFactorJ8);
        } else {
            scaleFactor = OSNativeUtils.getHighDPIScaleFactor_OSX_Java_9_or_Later(component);
        }
        if (scaleFactor == -1.0) {
            scaleFactor = 1.0;
        }
        return scaleFactor;
    }

    public static float getHighDPIScaleFactor_OSX_Java6() {
        float scaleFactor = -1.0f;
        Object obj = Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor");
        if (obj instanceof Float) {
            Float f = (Float)obj;
            scaleFactor = f.floatValue();
        }
        return scaleFactor;
    }

    private static double getHighDPIScaleFactor_OSX_Java_Pre_9(Component component) {
        double scaleFactor = -1.0;
        GraphicsDevice device = OSNativeUtils.getCurrentDevice(component);
        try {
            Method getScaleFactorMethod = device.getClass().getMethod("getScaleFactor", new Class[0]);
            Object scale = getScaleFactorMethod.invoke((Object)device, new Object[0]);
            if (scale instanceof Integer) {
                Integer intScale = (Integer)scale;
                scaleFactor = intScale.intValue();
            }
        }
        catch (Error err) {
            logger.debug("Reflection error? " + err);
            return -1.0;
        }
        catch (Exception e) {
            logger.debug("Reflection exception? " + e);
            return -1.0;
        }
        return scaleFactor;
    }

    private static double getHighDPIScaleFactor_OSX_Java_9_or_Later(Component component) {
        return OSNativeUtils.getCurrentConfiguration(component).getDefaultTransform().getScaleX();
    }

    private static GraphicsConfiguration getCurrentConfiguration(Component component) {
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return graphicsConfiguration;
    }

    private static GraphicsDevice getCurrentDevice(Component component) {
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        }
        return graphicsConfiguration.getDevice();
    }

    public static boolean isRunningDefectJFilechooserJVM() {
        logger.info("java ver" + OSNativeUtils.getJavaVersionAsDouble());
        String javaVersion = System.getProperty("java.version").toLowerCase();
        return OSNativeUtils.isWindows() && OSNativeUtils.getJavaVersionAsDouble() >= 7.0 && OSNativeUtils.getJavaVersionAsDouble() < 8.0;
    }

    private static double getJavaVersionAsDouble() {
        double version = 0.0;
        try {
            String javaVersion = System.getProperty("java.version").toLowerCase();
            logger.info("javaVersion" + javaVersion);
            String[] splitted = StringUtils.split(javaVersion, "._-");
            String major = "";
            String minor = "";
            if (splitted[0].equals("1")) {
                major = splitted[1];
                minor = splitted[3];
            } else {
                major = splitted[0];
                minor = splitted[2];
            }
            String versionString = major + "." + minor;
            version = Double.parseDouble(versionString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return version;
    }

    private static boolean isJavaVersion8orLower() {
        double javaVersion = OSNativeUtils.getJavaVersionAsDouble();
        logger.info("java_version=" + javaVersion);
        return javaVersion < 9.0;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isAnythingButMac() {
        return !OSNativeUtils.isMac();
    }

    public static boolean isLinuxOrUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static boolean isSolaris() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("sunos") >= 0;
    }

    public static boolean is32BitOS() {
        String os = System.getProperty("os.arch").toLowerCase();
        return os.indexOf("32") >= 0;
    }

    public static boolean is64BitOS() {
        String os = System.getProperty("os.arch").toLowerCase();
        return os.indexOf("64") >= 0;
    }

    public static boolean isPowerPC() {
        String os = System.getProperty("os.arch").toLowerCase();
        return os.indexOf("powerpc") >= 0;
    }

    public static KeyStroke getReloadKeyAccelerator() {
        return KeyStroke.getKeyStroke(82, 128);
    }

    public static KeyStroke getCopySelectionAsFastaKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(67, 256);
        }
        return KeyStroke.getKeyStroke(67, 128);
    }

    public static KeyStroke getCopyKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(67, 768);
        }
        return KeyStroke.getKeyStroke(67, 192);
    }

    public static int getMouseWheelZoomModifierMask() {
        if (OSNativeUtils.isMac()) {
            return 256;
        }
        return 128;
    }

    public static KeyStroke getPasteKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(86, 256);
        }
        return KeyStroke.getKeyStroke(86, 128);
    }

    public static KeyStroke getIncreaseFontSizeKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke('+');
        }
        return KeyStroke.getKeyStroke('+');
    }

    public static KeyStroke getDecreaseFontSizeKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke('-');
        }
        return KeyStroke.getKeyStroke('-');
    }

    public static KeyStroke getClearKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(127, 0);
        }
        return KeyStroke.getKeyStroke(127, 0);
    }

    public static KeyStroke getDeleteKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(8, 256);
        }
        return KeyStroke.getKeyStroke(127, 128);
    }

    public static KeyStroke getUndoKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(90, 256);
        }
        return KeyStroke.getKeyStroke(90, 128);
    }

    public static KeyStroke getRedoKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(89, 256);
        }
        return KeyStroke.getKeyStroke(89, 128);
    }

    public static KeyStroke getMoveSelectionUpKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(38, 256);
        }
        return KeyStroke.getKeyStroke(38, 128);
    }

    public static KeyStroke getMoveSelectionDownKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(40, 256);
        }
        return KeyStroke.getKeyStroke(40, 128);
    }

    public static KeyStroke getMoveSelectedRightKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(39, 256);
        }
        return KeyStroke.getKeyStroke(39, 128);
    }

    public static KeyStroke getMoveSelectedLeftKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(37, 256);
        }
        return KeyStroke.getKeyStroke(37, 128);
    }

    public static KeyStroke getInsertGapMoveRightKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(32, 0);
        }
        return KeyStroke.getKeyStroke(32, 0);
    }

    public static KeyStroke getInsertGapMoveLeftKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(32, 64);
        }
        return KeyStroke.getKeyStroke(32, 64);
    }

    public static KeyStroke getDeleteGapMoveLeftKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(8, 0);
        }
        return KeyStroke.getKeyStroke(8, 0);
    }

    public static KeyStroke getDeleteGapMoveRightKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(8, 64);
        }
        return KeyStroke.getKeyStroke(8, 64);
    }

    public static KeyStroke getToggleTranslationKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(84, 256);
        }
        return KeyStroke.getKeyStroke(84, 128);
    }

    public static KeyStroke getToggleIgnoreGapInTranslationKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(84, 320);
        }
        return KeyStroke.getKeyStroke(84, 640);
    }

    public static KeyStroke getSelectAllKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(65, 256);
        }
        return KeyStroke.getKeyStroke(65, 128);
    }

    public static KeyStroke getSelectionExpandRightKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(39, 576);
        }
        return KeyStroke.getKeyStroke(39, 576);
    }

    public static KeyStroke getSelectionExpandLeftKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(37, 576);
        }
        return KeyStroke.getKeyStroke(37, 576);
    }

    public static KeyStroke getSelectionExpandTopKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(38, 576);
        }
        return KeyStroke.getKeyStroke(38, 576);
    }

    public static KeyStroke getSelectionExpandDownKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(40, 576);
        }
        return KeyStroke.getKeyStroke(40, 576);
    }

    public static KeyStroke getToggleTranslationOnePosKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(84, 768);
        }
        return KeyStroke.getKeyStroke(84, 192);
    }

    public static KeyStroke getToggleTranslateShowBothKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(84, 512);
        }
        return KeyStroke.getKeyStroke(84, 512);
    }

    public static KeyStroke getToggleTranslateShowAACodeKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(84, 576);
        }
        return KeyStroke.getKeyStroke(84, 576);
    }

    public static KeyStroke getGoToPosKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(71, 256);
        }
        return KeyStroke.getKeyStroke(71, 128);
    }

    public static KeyStroke incReadingFrameKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(521, 64);
        }
        return KeyStroke.getKeyStroke(521, 64);
    }

    public static KeyStroke getExpandSelectionDownKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(40, 64);
        }
        return KeyStroke.getKeyStroke(40, 64);
    }

    public static KeyStroke decReadingFrameKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(45, 64);
        }
        return KeyStroke.getKeyStroke(45, 64);
    }

    public static KeyStroke countStopCodonsKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(67, 768);
        }
        return KeyStroke.getKeyStroke(67, 640);
    }

    public static KeyStroke getAddOrRemoveExcludesKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(69, 256);
        }
        return KeyStroke.getKeyStroke(69, 128);
    }

    public static KeyStroke getSaveFileAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(83, 256);
        }
        return KeyStroke.getKeyStroke(83, 128);
    }

    public static KeyStroke getOpenFileAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(79, 256);
        }
        return KeyStroke.getKeyStroke(79, 128);
    }

    public static KeyStroke getNewFileAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(78, 256);
        }
        return KeyStroke.getKeyStroke(78, 128);
    }

    public static KeyStroke getPrintAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(80, 256);
        }
        return KeyStroke.getKeyStroke(80, 128);
    }

    public static String getStandardCommandModifierKeyName() {
        if (OSNativeUtils.isMac()) {
            return "\u2318";
        }
        return "Ctrl";
    }

    public static KeyStroke getRenameKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(113, 0);
        }
        return KeyStroke.getKeyStroke(113, 0);
    }

    public static KeyStroke getCloseWinKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(87, 256);
        }
        return KeyStroke.getKeyStroke(87, 128);
    }

    public static KeyStroke getFocusNextWinKeyAccelerator() {
        if (OSNativeUtils.isMac()) {
            return KeyStroke.getKeyStroke(68, 256);
        }
        return KeyStroke.getKeyStroke(72, 128);
    }

    public static final void installGtkPopupBugWorkaround() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        Class<?> lafClass = laf.getClass();
        if (!lafClass.getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
            return;
        }
        try {
            Field field = lafClass.getDeclaredField("styleFactory");
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Object styleFactory = field.get(laf);
            field.setAccessible(accessible);
            Object style = OSNativeUtils.getGtkStyle(styleFactory, new JPopupMenu(), "POPUP_MENU");
            OSNativeUtils.fixGtkThickness(style, "yThickness");
            OSNativeUtils.fixGtkThickness(style, "xThickness");
            style = OSNativeUtils.getGtkStyle(styleFactory, new JSeparator(), "POPUP_MENU_SEPARATOR");
            OSNativeUtils.fixGtkThickness(style, "yThickness");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void fixGtkThickness(Object style, String fieldName) throws Exception {
        Field field = style.getClass().getDeclaredField(fieldName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        field.setInt(style, Math.max(1, field.getInt(style)));
        field.setAccessible(accessible);
    }

    private static Object getGtkStyle(Object styleFactory, JComponent component, String regionName) throws Exception {
        Class<?> regionClass = Class.forName("javax.swing.plaf.synth.Region");
        Field field = regionClass.getField(regionName);
        Object region = field.get(regionClass);
        Class<?> styleFactoryClass = styleFactory.getClass();
        Method method = styleFactoryClass.getMethod("getStyle", JComponent.class, regionClass);
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        Object style = method.invoke(styleFactory, component, region);
        method.setAccessible(accessible);
        return style;
    }

    public static boolean registerMacAdapter(AliView aliView) {
        boolean registerOK = false;
        if (OSNativeUtils.isMac()) {
            logger.info("register Mac Adapter");
            if (OSNativeUtils.isJavaVersion8orLower()) {
                logger.info("Doing pre-java-9 version of Mac application adapter via com.apple.eawt");
                DefaultApplication macApplication = new DefaultApplication();
                macApplication.addApplicationListener(aliView);
                macApplication.addPreferencesMenuItem();
                macApplication.setEnabledPreferencesMenu(true);
                registerOK = true;
            } else {
                logger.info("Doing java-9 version of Mac application adapter via javax.awt.desktop");
                OSXHandlerJava9 adapter = new OSXHandlerJava9();
                registerOK = true;
            }
        }
        return registerOK;
    }

    public static String getMonospacedFontName() {
        if (OSNativeUtils.isMac()) {
            return "Courier";
        }
        return "Monospaced";
    }
}

