/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class Utilities {
    private static final String LF = System.getProperty("line.separator");
    private static Properties environmentVars;

    public static void enableComponents(Container cont, boolean enable) {
        Component[] comps = cont.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setEnabled(enable);
            if (!(comps[i] instanceof Container)) continue;
            Utilities.enableComponents((Container)comps[i], enable);
        }
    }

    public static File assureFileSuffix(File file, String suffix) {
        if (file == null) {
            return file;
        }
        if (!file.getName().toUpperCase().endsWith(suffix.toUpperCase())) {
            file = new File(file.toString() + suffix);
        }
        return file;
    }

    public static File removeFileSuffix(File file) {
        if (file == null) {
            return file;
        }
        int endPos = file.toString().indexOf(".");
        if (endPos > -1) {
            String newName = file.toString().substring(0, endPos);
            file = new File(newName);
        }
        return file;
    }

    public static byte[] stringToTerminatedByteArray(String inString) {
        if (inString == null) {
            return null;
        }
        byte[] temp = inString.getBytes();
        byte[] chrStr = new byte[temp.length + 1];
        System.arraycopy(temp, 0, chrStr, 0, temp.length);
        return chrStr;
    }

    public static File saveFileViaChooser(File theFile, String suffix, InputStream fileStream, JFrame frame) {
        boolean fileSaved = false;
        System.err.println("Inne i saveFileViaChooser");
        JFileChooser fileChooser = new JFileChooser();
        if (suffix == null) {
            suffix = Utilities.getFileSuffix(theFile);
        }
        System.err.println("Hit");
        fileChooser.setFileSystemView(FileSystemView.getFileSystemView());
        fileChooser.setSelectedFile(theFile);
        while (fileChooser.showSaveDialog(frame) == 0) {
            boolean shouldSaveFile = true;
            theFile = fileChooser.getSelectedFile();
            if ((theFile = Utilities.assureFileSuffix(theFile, suffix)).exists()) {
                String question = theFile.toString() + "," + LF + "finns redan, vill du ers\u00e4tta den?";
                int result = JOptionPane.showOptionDialog(frame, question, "Ers\u00e4tt?", 0, 3, null, new Object[]{"Ja", "Nej"}, "Nej");
                if (result == 1) {
                    shouldSaveFile = false;
                } else if (!theFile.canWrite()) {
                    System.err.println("Kan inte skriva");
                    JOptionPane.showOptionDialog(frame, "Det g\u00e5r inte att ers\u00e4tta filen," + LF + "den kanske anv\u00e4nds eller \u00e4r skrivskyddad.", "G\u00e5r ej att ers\u00e4tta", 0, 2, null, new Object[]{"Ok"}, "Ok");
                    shouldSaveFile = false;
                }
            }
            if (!shouldSaveFile) continue;
            if (fileSaved) break;
            JOptionPane.showOptionDialog(frame, "Det gick inte att spara filen," + LF + "kanske det saknas r\u00e4ttigheter" + LF + "eller den kanske anv\u00e4nds.", "G\u00e5r ej att spara", 0, 2, null, new Object[]{"Ok"}, "Ok");
        }
        if (fileSaved) {
            return theFile;
        }
        return null;
    }

    public static String getUserDir() {
        String userdir = Utilities.getEnv("HOMEDRIVE") + Utilities.getEnv("HOMEPATH");
        if (userdir == null) {
            userdir = System.getProperty("user.dir");
        }
        if (userdir == null) {
            userdir = System.getProperty("user.home");
        }
        if (userdir == null) {
            userdir = System.getProperty("java.io.tmpdir");
        }
        if (userdir == null) {
            userdir = "";
        }
        return userdir;
    }

    public static String getEnv(String env) {
        String envVarValue = null;
        System.err.println("(env)" + env + "=" + envVarValue);
        if (envVarValue == null) {
            if (environmentVars == null) {
                environmentVars = new Properties();
                try {
                    String inLine;
                    InputStream is = Runtime.getRuntime().exec("cmd /c set").getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);
                    while ((inLine = br.readLine()) != null) {
                        String property = inLine.substring(0, inLine.indexOf(61));
                        String value = inLine.substring(inLine.indexOf(61) + 1);
                        environmentVars.setProperty(property, value);
                    }
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            envVarValue = environmentVars.getProperty(env);
        }
        return envVarValue;
    }

    public static void runProgram(String programName, String parameters) throws Exception {
        String command = "";
        String os = System.getProperty("os.name");
        command = "Windows 95".equalsIgnoreCase(os) || "Windows ME".equalsIgnoreCase(os) || "Windows 98".equalsIgnoreCase(os) ? "start " + programName + " " + parameters : "cmd /c start " + programName + " " + parameters;
        Runtime.getRuntime().exec(command);
    }

    public static void adjustFonts(String fontName, int fontSize) {
        UIDefaults defaults = UIManager.getDefaults();
        Vector<Object> newDefaults = new Vector<Object>();
        Enumeration e = defaults.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Font value = defaults.getFont(key);
            if (value == null) continue;
            Font oldFont = value;
            Font newFont = new Font(fontName, 0, fontSize);
            newDefaults.add(key);
            newDefaults.add(newFont);
        }
        defaults.putDefaults(newDefaults.toArray());
    }

    public static void adjustColors(Color oldColor, Color newColor) {
        UIDefaults defaults = UIManager.getDefaults();
        Vector<Object> newDefaults = new Vector<Object>();
        Enumeration e = defaults.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Color value = defaults.getColor(key);
            if (value == null) continue;
            Color defaultColor = value;
            System.err.println(key + " R=" + defaultColor.getRed() + " G=" + defaultColor.getGreen() + " B=" + defaultColor.getBlue() + " A=" + defaultColor.getAlpha());
            if (!oldColor.equals(defaultColor)) continue;
            Color newDefaultColor = new Color(newColor.getRGB());
            newDefaults.add(key);
            newDefaults.add(newDefaultColor);
        }
        defaults.putDefaults(newDefaults.toArray());
    }

    public static String getFileSuffix(File file) {
        String suffix = "";
        String fileName = file.toString();
        int pos = fileName.lastIndexOf(".");
        if (pos > -1) {
            suffix = fileName.substring(pos);
        }
        return suffix;
    }

    public static boolean isWritePossible(File testFile) {
        if (testFile == null) {
            return false;
        }
        try {
            FileOutputStream fileOutStream = new FileOutputStream(testFile);
            fileOutStream.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        testFile.delete();
        return true;
    }

    public static NumberFormat getNumberInstance() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        if (nf instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)nf;
            DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            df.setDecimalFormatSymbols(dfs);
        }
        return nf;
    }

    public static String adjustDecimalSymbol(String input) {
        if (input == null) {
            return null;
        }
        String output = input.replace(',', '.');
        return output;
    }
}

