/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import org.apache.log4j.Logger;
import utils.nexus.Range;

public class CodonRange
extends Range {
    private static final Logger logger = Logger.getLogger(CodonRange.class);

    public CodonRange(int start, int end, int startVal) {
        super(start, end, startVal);
    }

    @Override
    public CodonRange getCopy() {
        return new CodonRange(this.start, this.end, this.startVal);
    }

    public static CodonRange newDefaultRange() {
        return new CodonRange(0, 2147482647, 1);
    }

    public int countAllCodons(int readingFrame) {
        return this.countCodonsUntil(this.end, readingFrame);
    }

    public int countCodonsUntil(int endPos, int readingFrame) {
        if (this.startVal == 0) {
            int positions = this.end - this.start;
            int retVal = (int)Math.ceil((double)(endPos - this.start + 1) / 3.0);
            return retVal;
        }
        int startCorrected = this.getFirstFullFrameStartPos(readingFrame);
        int count = 0;
        if (this.start != startCorrected) {
            ++count;
        }
        return count += (int)Math.ceil((double)(endPos - startCorrected + 1) / 3.0);
    }

    public boolean containsCodonPos(int pos, int offset, int readingFrame) {
        int maxPos = offset + this.countAllCodons(readingFrame) - 1;
        return pos <= maxPos;
    }

    public int getPosAtCodonPos(int codonPos, int readingFrame) {
        if (codonPos == 0) {
            return this.start;
        }
        int correctedStart = this.getFirstFullFrameStartPos(readingFrame);
        int pos = this.start == correctedStart ? this.start + codonPos * 3 : correctedStart + (codonPos - 1) * 3;
        return pos;
    }

    private int getFirstFullFrameStartPos(int readingFrame) {
        if (this.startVal == 0) {
            return this.start;
        }
        int startCorrected = this.start;
        if (readingFrame - this.startVal != 0) {
            int codonStartOffset = readingFrame - this.startVal;
            if (codonStartOffset < 0) {
                codonStartOffset = 3 + codonStartOffset;
            }
            startCorrected = this.start + codonStartOffset;
        }
        return startCorrected;
    }
}

