/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import utils.nexus.NexusRange;

public class NexusBoolArray {
    private static final Logger logger = Logger.getLogger(NexusBoolArray.class);
    private boolean[] backend;

    public NexusBoolArray(int length) {
        this.backend = new boolean[length];
    }

    public NexusBoolArray(boolean[] positions) {
        this.backend = positions;
    }

    public boolean[] getBooleanArray() {
        return this.backend;
    }

    public NexusBoolArray getCopy() {
        return new NexusBoolArray(ArrayUtils.clone(this.backend));
    }

    public void reverse() {
        ArrayUtils.reverse(this.backend);
    }

    public int getLength() {
        if (this.backend != null) {
            return this.backend.length;
        }
        return 0;
    }

    public boolean valueAt(int position) {
        if (!this.rangeCheck(position)) {
            return false;
        }
        return this.backend[position];
    }

    public boolean containsValue(boolean value) {
        if (this.backend != null) {
            for (boolean position : this.backend) {
                if (position != value) continue;
                return true;
            }
        }
        return false;
    }

    public void removePosition(int index) {
        if (this.rangeCheck(index)) {
            this.backend = ArrayUtils.remove(this.backend, index);
        }
    }

    public void set(int pos, boolean b) {
        this.backend[pos] = b;
    }

    private boolean rangeCheck(int index) {
        if (this.backend == null) {
            return false;
        }
        return this.backend.length > index;
    }

    public int countValue(boolean value) {
        int size = 0;
        if (this.backend != null) {
            for (boolean position : this.backend) {
                if (position != value) continue;
                ++size;
            }
        }
        return size;
    }

    public void setTrueFromNexusRange(NexusRange range) {
        for (int n = range.getMinimumInt(); n <= range.getMaximumInt(); ++n) {
            if (!this.rangeCheck(n - 1)) continue;
            this.backend[n - 1] = true;
        }
    }

    public void debug() {
        logger.info(this.backend);
        for (boolean bl : this.backend) {
        }
    }

    public void append(NexusBoolArray morePositions) {
        int newSize = this.backend.length + morePositions.getBooleanArray().length;
        boolean[] newPositions = new boolean[newSize];
        System.arraycopy(this.backend, 0, newPositions, 0, this.backend.length);
        System.arraycopy(morePositions.getBooleanArray(), 0, newPositions, this.backend.length, morePositions.getBooleanArray().length);
        this.backend = newPositions;
    }

    public void insertPosition(int n) {
        if (this.backend != null) {
            this.backend = ArrayUtils.add(this.backend, n, false);
        }
    }

    public boolean isTrueValContinous() {
        boolean searchVal = true;
        boolean firstFound = false;
        boolean isInterruptedOnce = false;
        boolean isContinous = false;
        if (this.backend != null) {
            int n = 0;
            while (n + 1 < this.backend.length) {
                boolean positionVal = this.backend[n];
                boolean nextPosVal = this.backend[n + 1];
                if (positionVal == searchVal && !firstFound) {
                    firstFound = true;
                    isContinous = true;
                }
                if (positionVal != searchVal && firstFound) {
                    isInterruptedOnce = true;
                }
                if (positionVal && firstFound && isInterruptedOnce) {
                    isContinous = false;
                }
                ++n;
            }
        }
        return isContinous;
    }
}

