/*
 * Decompiled with CFR 0.152.
 */
package utils.nexus;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import utils.nexus.CodonRange;
import utils.nexus.NexusRange;
import utils.nexus.Ranges;

public class NexusRangesTranslator {
    private static final Logger logger = Logger.getLogger(NexusRangesTranslator.class);
    private ArrayList<NexusRange> nexusRanges = new ArrayList();

    public void addNexusRanges(ArrayList<NexusRange> allRanges) {
        this.nexusRanges.addAll(allRanges);
    }

    public Ranges convertToCodonRanges() {
        Ranges allRanges = new Ranges();
        allRanges.addRange(CodonRange.newDefaultRange());
        int min = this.getMinPos() - 1;
        int max = this.getMaxPos() - 1;
        int startVal = this.getPosVal(min - 1);
        CodonRange codonRange = new CodonRange(min - 1, max - 1, startVal);
        int defaultStartVal = 1;
        int startValOffset = startVal - defaultStartVal;
        for (int n = min; n <= max; ++n) {
            int target = n % 3 + 1;
            int targetModifiedWithStartValOffset = target + startValOffset;
            if (targetModifiedWithStartValOffset > 3) {
                targetModifiedWithStartValOffset -= 3;
            }
            if ((startVal = this.getPosVal(n)) == targetModifiedWithStartValOffset || startVal == 0 && codonRange.startVal == 0) continue;
            codonRange.end = n - 1;
            codonRange = new CodonRange(n, max, startVal);
            allRanges.addRange(codonRange);
            startValOffset = startVal - target;
            if (startValOffset >= 0) continue;
            startValOffset += 3;
        }
        allRanges.debug();
        return allRanges;
    }

    public Ranges convertToCharsetRanges() {
        Ranges allRanges = new Ranges();
        allRanges.addRange(CodonRange.newDefaultRange());
        int min = this.getMinPos() - 1;
        int max = this.getMaxPos() - 1;
        int startVal = this.getPosVal(min - 1);
        CodonRange codonRange = new CodonRange(min - 1, max - 1, startVal);
        int defaultStartVal = 1;
        int startValOffset = startVal - defaultStartVal;
        for (int n = min; n <= max; ++n) {
            int target = n % 3 + 1;
            int targetModifiedWithStartValOffset = target + startValOffset;
            if (targetModifiedWithStartValOffset > 3) {
                targetModifiedWithStartValOffset -= 3;
            }
            if ((startVal = this.getPosVal(n)) == targetModifiedWithStartValOffset || startVal == 0 && codonRange.startVal == 0) continue;
            codonRange.end = n - 1;
            codonRange = new CodonRange(n, max, startVal);
            allRanges.addRange(codonRange);
            startValOffset = startVal - target;
            if (startValOffset >= 0) continue;
            startValOffset += 3;
        }
        allRanges.debug();
        return allRanges;
    }

    private int getMinPos() {
        int minVal = Integer.MAX_VALUE;
        for (NexusRange range : this.nexusRanges) {
            minVal = Math.min(minVal, range.getMinimumInt());
        }
        return minVal;
    }

    private int getMaxPos() {
        int maxVal = Integer.MIN_VALUE;
        for (NexusRange range : this.nexusRanges) {
            maxVal = Math.max(maxVal, range.getMaximumInt());
        }
        return maxVal;
    }

    private int getPosVal(int n) {
        ++n;
        for (NexusRange range : this.nexusRanges) {
            int posInRange;
            int rest;
            if (n < range.getMinimumInt() || n > range.getMaximumInt() || (rest = (posInRange = n - range.getMinimumInt()) % range.getSteps()) != 0) continue;
            return range.positionVal;
        }
        return 0;
    }
}

